/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.synth;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerStartEvent;
import ipsk.audio.synth.SineWaveGeneratorSource;
import javax.sound.sampled.AudioFormat;

public class SinusTestSineWavePlayer
implements PlayerListener {
    private SineWaveGeneratorSource swgs = new SineWaveGeneratorSource(this.DEFAULT_FREQUENCY, 0.8f, new AudioFormat(44000.0f, 16, 2, true, false), -1L);
    private Player player = new Player();
    private float DEFAULT_FREQUENCY = 377.0f;

    public SinusTestSineWavePlayer() throws AudioFormatNotSupportedException, PlayerException {
        this.player.setUseAWTEventThread(false);
        this.player.setAudioSource(this.swgs);
        this.player.addPlayerListener(this);
    }

    public void start() throws PlayerException {
        System.out.println("Opening sine wave player");
        this.player.open();
    }

    public void stop() throws PlayerException {
        System.out.println("Closing sine wave player");
        this.player.close();
    }

    @Override
    public void update(PlayerEvent playerEvent) {
        if (playerEvent instanceof PlayerOpenEvent) {
            System.out.println("Sine wave player opened.");
            this.player.start();
        } else if (playerEvent instanceof PlayerStartEvent) {
            System.out.println("Sine wave player running.");
        } else if (playerEvent instanceof PlayerCloseEvent) {
            System.out.println("Sine wave player closed.");
        }
    }

    public static void main(String[] args) {
        try {
            final SinusTestSineWavePlayer swp = new SinusTestSineWavePlayer();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        System.out.println("Shutdown hook...");
                        swp.stop();
                    }
                    catch (PlayerException e) {
                        e.printStackTrace();
                    }
                }
            });
            swp.start();
        }
        catch (AudioFormatNotSupportedException | PlayerException e) {
            e.printStackTrace();
        }
    }
}

