/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tools;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.Statistic;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class CrackFinder {
    private int threshold;
    private boolean bigEndian;
    private boolean signed = false;
    static final boolean DEBUG = false;
    byte[] data;
    int length;
    AudioFormat af;
    int channels;
    int frameSize;
    int sampleSize;
    int frames;
    int[] last;
    float maxValue;
    float minValue;
    int resolutionBits;
    float pp;
    float ln = (float)(20.0 / Math.log(10.0));
    boolean processing = false;
    Statistic s;
    AudioFormat.Encoding ae;

    public CrackFinder(AudioFormat af, int threshold) throws AudioFormatNotSupportedException {
        this.af = af;
        this.threshold = threshold;
        if (af.getSampleSizeInBits() > 64) {
            throw new AudioFormatNotSupportedException(af);
        }
        this.ae = af.getEncoding();
        if (this.ae != AudioFormat.Encoding.PCM_SIGNED) {
            if (this.ae == AudioFormat.Encoding.PCM_UNSIGNED) {
                throw new AudioFormatNotSupportedException(af);
            }
            throw new AudioFormatNotSupportedException(af);
        }
        this.signed = true;
        this.resolutionBits = af.getSampleSizeInBits();
        this.pp = (float)Math.pow(2.0, this.resolutionBits);
        this.maxValue = this.pp / 2.0f;
        this.minValue = -this.maxValue + 1.0f;
        this.channels = af.getChannels();
        this.frameSize = af.getFrameSize();
        this.sampleSize = this.frameSize / af.getChannels();
        this.bigEndian = af.isBigEndian();
        this.last = new int[this.channels];
    }

    protected int getSampleValue(byte[] sample) {
        int is = 0;
        int size = sample.length;
        if (this.signed) {
            int i;
            if (!this.bigEndian) {
                for (i = size - 1; i > 0; --i) {
                    is |= 0xFF & sample[i];
                    is <<= 8;
                }
                is |= 0xFF & sample[0];
            } else {
                for (i = 0; i < size - 1; ++i) {
                    is |= 0xFF & sample[i];
                    is <<= 8;
                }
                is |= 0xFF & sample[size - 1];
            }
            if (size == 1) {
                byte b = (byte)is;
                is = b;
            } else if (size == 2) {
                short s = (short)is;
                is = s;
            }
        }
        return is;
    }

    public void findCracks(File file, AudioInputStream ais) throws UnsupportedAudioFileException, IOException {
        this.frames = (int)ais.getFrameLength();
        this.data = new byte[(int)((long)ais.getFormat().getFrameSize() * (long)this.frames)];
        ais.read(this.data, 0, this.data.length);
        int bc = 0;
        byte[] sample = new byte[this.sampleSize];
        int[] val = new int[this.channels];
        int[] delta = new int[this.channels];
        for (long f = 0L; f < (long)this.frames; ++f) {
            for (int ch = 0; ch < this.channels; ++ch) {
                for (int i = 0; i < this.sampleSize; ++i) {
                    sample[i] = this.data[bc++];
                }
                val[ch] = this.getSampleValue(sample);
                delta[ch] = val[ch] - this.last[ch];
                if (Math.abs(delta[ch]) > this.threshold) {
                    System.out.println(file.getAbsolutePath() + " " + f + " delta: " + delta[ch]);
                }
                this.last[ch] = val[ch];
            }
        }
    }

    public static void main(String[] args) {
        for (int i = 1; i < args.length; ++i) {
            File f = new File(args[i]);
            try {
                AudioInputStream ais = AudioSystem.getAudioInputStream(f);
                CrackFinder cf = new CrackFinder(ais.getFormat(), Integer.parseInt(args[0]));
                cf.findCracks(f, ais);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

