package ipsk.audio.synth;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;


import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.player.Player;
import ipsk.audio.player.PlayerException;
import ipsk.audio.player.PlayerListener;
import ipsk.audio.player.event.PlayerCloseEvent;
import ipsk.audio.player.event.PlayerEvent;
import ipsk.audio.player.event.PlayerOpenEvent;
import ipsk.audio.player.event.PlayerStartEvent;

public class SinusTestSineWavePlayer implements PlayerListener {

	private SineWaveGeneratorSource swgs;
	private Player player;
	
	private float DEFAULT_FREQUENCY=377;
	
	
	public SinusTestSineWavePlayer() throws AudioFormatNotSupportedException, PlayerException {
		super();
		swgs=new SineWaveGeneratorSource(DEFAULT_FREQUENCY,(float)0.8, new AudioFormat(44000, 16, 2, true, false), (long)AudioSystem.NOT_SPECIFIED);
		player=new Player();
		player.setUseAWTEventThread(false);
		player.setAudioSource(swgs);
		player.addPlayerListener(this);
		
		
	}
	
	public void start() throws PlayerException {
		System.out.println("Opening sine wave player");
		player.open();
	}
	
	public void stop() throws PlayerException {
		System.out.println("Closing sine wave player");
		player.close();
	}
	

	@Override
	public void update(PlayerEvent playerEvent) {
		if(playerEvent instanceof PlayerOpenEvent) {
			System.out.println("Sine wave player opened.");
			player.start();
		}else if(playerEvent instanceof PlayerStartEvent) {
			System.out.println("Sine wave player running.");
		}else if(playerEvent instanceof PlayerCloseEvent) {
			System.out.println("Sine wave player closed.");
		}
		
	}
	
	
	public static void main(String[] args) {
		
		try {
			SinusTestSineWavePlayer swp=new SinusTestSineWavePlayer();
			 Runtime.getRuntime().addShutdownHook(new Thread() {
				  public void run() { 
					  try {
						  System.out.println("Shutdown hook...");
						swp.stop();
					} catch (PlayerException e) {
						
						e.printStackTrace();
					}
			      } 
			 });
			swp.start();
		} catch (AudioFormatNotSupportedException | PlayerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
	}

	

}
