/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.ControlUI;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.sampled.EnumControl;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class EnumControlUI
extends ControlUI
implements ActionListener {
    private EnumControl ec;
    private Object[] objects;
    private JRadioButton[] boxes;
    private boolean updating = false;

    public EnumControlUI(EnumControl ec) {
        super(ec.getType().toString());
        this.ec = ec;
        this.objects = ec.getValues();
        this.setLayout(new GridLayout(this.objects.length, 1));
        this.boxes = new JRadioButton[this.objects.length];
        ButtonGroup group = new ButtonGroup();
        for (int i = 0; i < this.objects.length; ++i) {
            this.boxes[i] = new JRadioButton(this.objects[i].toString());
            this.boxes[i].addActionListener(this);
            group.add(this.boxes[i]);
            this.add(this.boxes[i]);
        }
        this.updateValue();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (!this.updating) {
            for (int i = 0; i < this.boxes.length; ++i) {
                if (!ae.getSource().equals(this.boxes[i])) continue;
                this.ec.setValue(this.objects[i]);
            }
        }
    }

    @Override
    public void updateValue() {
        for (int i = 0; i < this.objects.length; ++i) {
            if (!this.ec.getValue().equals(this.objects[i])) continue;
            this.updating = true;
            if (!this.boxes[i].isSelected()) {
                this.boxes[i].setSelected(true);
            }
            this.updating = false;
        }
    }
}

