/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioPluginException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.SourcePlugin;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.TransferableAudioSource;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class PluginChain
implements TransferableAudioSource {
    public static final DataFlavor DATA_FLAVOR = new DataFlavor(PluginChain.class, "Audio Plugin Chain");
    private AudioSource source;
    private Vector<AudioPlugin> plugins;
    private Long frameLengthObj = null;
    private static final DataFlavor[] dataFlavors = new DataFlavor[]{AudioSource.DATA_FLAVOR, DATA_FLAVOR};
    private AudioFormat format;
    private boolean valid = true;

    public PluginChain(AudioSource source) {
        this.source = source;
        this.plugins = new Vector();
    }

    public Object clone() {
        PluginChain clone = new PluginChain(this.source);
        clone.plugins = (Vector)this.plugins.clone();
        return clone;
    }

    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        if (!this.valid) {
            throw new AudioSourceException("Plugin chain data invalid !");
        }
        AudioInputStream ais = this.source.getAudioInputStream();
        for (int i = 0; i < this.plugins.size(); ++i) {
            AudioPlugin ap = this.plugins.get(i);
            try {
                ais = ap.getAudioInputStream(ais);
                continue;
            }
            catch (AudioPluginException e) {
                throw new AudioSourceException(e);
            }
        }
        this.frameLengthObj = new Long(ais.getFrameLength());
        this.format = ais.getFormat();
        return ais;
    }

    private void getSourceFormat() {
        AudioInputStream ais = null;
        this.format = null;
        try {
            ais = this.source.getAudioInputStream();
            this.format = ais.getFormat();
        }
        catch (AudioSourceException audioSourceException) {
        }
        finally {
            if (ais != null) {
                try {
                    ais.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void add(AudioPlugin newPlugin) throws AudioFormatNotSupportedException {
        if (this.format == null && this.plugins.size() == 0) {
            this.getSourceFormat();
        }
        if (this.format != null) {
            AudioFormat apFormat = newPlugin.getInputFormat();
            if (apFormat == null) {
                newPlugin.setInputFormat(this.format);
            } else if (!apFormat.matches(this.format)) {
                throw new AudioFormatNotSupportedException(apFormat);
            }
        }
        this.format = newPlugin.getOutputFormat();
        this.plugins.add(newPlugin);
        this.frameLengthObj = null;
    }

    public AudioPlugin get(int i) {
        return this.plugins.get(i);
    }

    public AudioPlugin removeLast() {
        AudioPlugin lastPlugin = this.plugins.remove(this.plugins.size() - 1);
        this.format = this.plugins.lastElement().getOutputFormat();
        this.frameLengthObj = null;
        return lastPlugin;
    }

    public int size() {
        return this.plugins.size();
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        if (this.valid) {
            return dataFlavors;
        }
        return new DataFlavor[0];
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor arg0) {
        if (!this.valid) {
            return false;
        }
        for (int i = 0; i < dataFlavors.length; ++i) {
            if (!arg0.equals(dataFlavors[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor arg0) throws UnsupportedFlavorException, IOException {
        if (!this.valid) {
            throw new IOException("Transfer data is invalid !");
        }
        if (this.isDataFlavorSupported(arg0)) {
            return this;
        }
        return null;
    }

    @Override
    public AudioFormat getFormat() throws AudioSourceException {
        if (this.format == null) {
            AudioInputStream dummyStream = this.getAudioInputStream();
            try {
                dummyStream.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
        }
        return this.format;
    }

    @Override
    public long getFrameLength() throws AudioSourceException {
        if (this.frameLengthObj == null) {
            AudioInputStream dummyStream = this.getAudioInputStream();
            try {
                dummyStream.close();
            }
            catch (IOException e) {
                throw new AudioSourceException(e);
            }
        }
        if (this.frameLengthObj == null) {
            return ThreadSafeAudioSystem.NOT_SPECIFIED;
        }
        return this.frameLengthObj;
    }

    public File[] getUsedAudioFiles() {
        ArrayList<File> afList = new ArrayList<File>();
        if (this.source instanceof FileAudioSource) {
            afList.add(((FileAudioSource)this.source).getFile());
        }
        for (AudioPlugin ap : this.plugins) {
            AudioSource as;
            if (!(ap instanceof SourcePlugin) || !((as = ((SourcePlugin)((Object)ap)).getAudioSource()) instanceof FileAudioSource)) continue;
            afList.add(((FileAudioSource)this.source).getFile());
        }
        return afList.toArray(new File[0]);
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }
}

