/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.ui.FourierRendererEvent;
import ipsk.audio.arr.clip.ui.FourierRendererListener;
import ipsk.audio.dsp.BufferedFloatRandomAccessStream;
import ipsk.audio.dsp.DSPUtils;
import ipsk.audio.dsp.FourierAudioInputStream;
import ipsk.math.Complex;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.image.BufferedImage;

public class FourierRenderer
implements Runnable {
    private static final boolean DEBUG = false;
    private static final boolean CALC_MAXIMUM = true;
    private static final boolean CONSIDER_PRE_EMPHASIS_CALC_MAXIMUM = true;
    private static final int DEFAULT_NOTIFY_ON_PIXELS = 200;
    private static final int WAIT_FOR_THREAD_ON_CLOSE = 20000;
    private AudioSource audioSource;
    private volatile Request request = new Request();
    private Complex[][][] buf = null;
    private volatile RenderResult rs = null;
    private Thread thread = null;
    private volatile Object threadNotify = new Object();
    private volatile boolean open = true;
    private FourierRendererListener listener;
    private int notifyOnPixels = 200;
    private Double totalMaximum = null;
    private Double maxPsd = null;

    public FourierRenderer(AudioSource audioSource, FourierRendererListener listener) throws AudioFormatNotSupportedException, AudioSourceException {
        this.audioSource = audioSource;
        this.listener = listener;
    }

    public RenderResult render(int fromPixel, int toPixel, int height, double framesPerPixel, int n, int windowSize, double dynRangeInDb, boolean useThread) throws AudioSourceException {
        return this.render(fromPixel, toPixel, height, n / 2, framesPerPixel, n, windowSize, dynRangeInDb, useThread);
    }

    public RenderResult render(int fromPixel, int toPixel, int height, double maxFrequency, double framesPerPixel, int n, int windowSize, double dynRangeInDb, boolean useThread) throws AudioSourceException {
        return this.render(fromPixel, toPixel, height, maxFrequency, framesPerPixel, n, windowSize, dynRangeInDb, 0.0, 0.0, useThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderResult render(int fromPixel, int toPixel, int height, double maxFrequency, double framesPerPixel, int n, int windowSize, double dynRangeInDb, double emphasisPerOctave, double emphasisStartFreq, boolean useThread) throws AudioSourceException {
        boolean render = false;
        Object object = this.threadNotify;
        synchronized (object) {
            Request newRequest = new Request(fromPixel, toPixel, height, maxFrequency, framesPerPixel, n, windowSize, dynRangeInDb, emphasisPerOctave, emphasisStartFreq);
            if (useThread && newRequest.equals(this.request)) {
                this.rs.offset = 0;
                this.rs.length = this.rs.values.length;
                return this.rs;
            }
            long startFramePos = (long)(framesPerPixel * (double)newRequest.fromPixel);
            int startValuePixelPos = (int)((double)startFramePos / framesPerPixel);
            long endFramePos = (long)(framesPerPixel * (double)newRequest.toPixel) + 1L;
            int endValuePixelPos = (int)((double)endFramePos / framesPerPixel);
            if (!useThread || !newRequest.isIn(this.request)) {
                if (this.rs != null) {
                    this.rs.isValid = false;
                }
                int length = endValuePixelPos - startValuePixelPos;
                int channels = this.audioSource.getFormat().getChannels();
                this.rs = new RenderResult(length, n, channels);
                this.rs.pixelOffset = startValuePixelPos;
                this.rs.offset = 0;
                this.rs.length = length;
                this.rs.renderedLength = 0;
                this.rs.rendered = false;
                newRequest.checkCalculateMaxRequired(this.request);
                this.request.copy(newRequest);
                int reqWidth = this.request.toPixel - this.request.fromPixel;
                if (height == 0 || reqWidth <= 0) {
                    this.rs.renderedImages = null;
                } else {
                    this.rs.renderedImages = new BufferedImage[channels];
                    for (int ch = 0; ch < channels; ++ch) {
                        this.rs.renderedImages[ch] = new BufferedImage(reqWidth, height, 5);
                    }
                }
                render = true;
            } else {
                this.rs.offset = startValuePixelPos - this.rs.pixelOffset;
                this.rs.length = endValuePixelPos - startValuePixelPos;
            }
            if (render || !useThread) {
                if (useThread) {
                    if (this.thread == null) {
                        this.thread = new Thread((Runnable)this, "FourierRenderer");
                        this.thread.setPriority(1);
                        this.thread.start();
                        this.thread.setPriority(1);
                    }
                    this.threadNotify.notifyAll();
                } else {
                    try {
                        this._render(this.request.calculationOfMaxRequired, this.request.fromPixel, this.request.toPixel, this.request.framesPerPixel, this.request.n, this.request.windowSize, this.request.dynRangeInDb, this.request.height, this.request.maxFrequency, this.request.emphasisPerOctave, this.request.emphasisStartFreq);
                    }
                    catch (AudioSourceException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return this.rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                this._render(this.request.calculationOfMaxRequired, this.request.fromPixel, this.request.toPixel, this.request.framesPerPixel, this.request.n, this.request.windowSize, this.request.dynRangeInDb, this.request.height, this.request.maxFrequency, this.request.emphasisPerOctave, this.request.emphasisStartFreq);
            }
            catch (AudioSourceException e) {
                e.printStackTrace();
            }
            Object object = this.threadNotify;
            synchronized (object) {
                while (this.open && (this.rs == null || !this.rs.isValid || this.rs.rendered)) {
                    try {
                        this.threadNotify.wait(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } while (this.open);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void _render(boolean calculationOfMaxRequired, int startPixel, int endPixel, double framesPerPixel, int n, int windowSize, double dynRangeInDb, int height, double maxFrequency, double emphasisPerOctave, double emphasisStartFreq) throws AudioSourceException {
        BufferedFloatRandomAccessStream fras;
        RenderResult rs = null;
        Object object = this.threadNotify;
        synchronized (object) {
            rs = this.rs;
        }
        try {
            fras = new BufferedFloatRandomAccessStream(this.audioSource);
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
            throw new AudioSourceException(e);
        }
        FourierAudioInputStream fouAis = new FourierAudioInputStream(fras);
        fouAis.setNAndWindowSize(n, windowSize);
        int channels = fouAis.getChannels();
        long framePos = 0L;
        if (this.buf == null || channels > this.buf[0].length || n > this.buf[0][0].length) {
            this.buf = new Complex[1][channels][n];
        }
        if (this.totalMaximum == null || calculationOfMaxRequired) {
            this.maxPsd = 0.0;
            long start = System.currentTimeMillis();
            int step = (int)framesPerPixel;
            if (step < windowSize) {
                step = windowSize;
            }
            if (framesPerPixel < 1.0) {
                framesPerPixel = 1.0;
            }
            double totalMax = Double.MIN_VALUE;
            fouAis.setFramePosition(framePos);
            long frameLength = fouAis.getFrameLength();
            while (fouAis.readFrame(this.buf, 0) && this.open) {
                for (int i = 0; i < channels; ++i) {
                    for (int ni = 0; ni < n / 2; ++ni) {
                        double mag = this.buf[0][i][ni].magnitude();
                        double psd = 2.0 * Math.pow(mag, 2.0) / (double)windowSize;
                        if (emphasisPerOctave != 0.0 && (double)ni >= emphasisStartFreq) {
                            double emphFactorInDB = DSPUtils.toOctaves((double)ni / emphasisStartFreq) * emphasisPerOctave;
                            double emphFactor = DSPUtils.toLinearLevel(emphFactorInDB);
                            psd *= emphFactor;
                        }
                        if (this.maxPsd < psd) {
                            this.maxPsd = psd;
                        }
                        if (!(totalMax < mag)) continue;
                        totalMax = mag;
                    }
                }
                if ((framePos += (long)step) >= frameLength) break;
                Thread.yield();
                fouAis.setFramePosition(framePos);
            }
            this.totalMaximum = totalMax;
            rs.totalMaximum = totalMax;
        }
        int lastValuePixelPos = -1;
        int minRgbVal = 255;
        int renderedPixels = 0;
        int xOffset = 0;
        for (int pixelPos = startPixel; pixelPos <= endPixel && rs.isValid; ++pixelPos) {
            void var37_49;
            void var37_47;
            framePos = (long)(framesPerPixel * (double)pixelPos);
            int valuePixelPos = (int)((double)framePos / framesPerPixel);
            if (valuePixelPos == lastValuePixelPos) {
                // empty if block
            }
            long nextFramePos = (long)(framesPerPixel * (double)(pixelPos + 1));
            long lastFrame = (long)(framesPerPixel * (double)(endPixel + 1));
            long frameLength = fouAis.getFrameLength();
            if (frameLength != -1L && lastFrame > frameLength - 1L) {
                lastFrame = frameLength - 1L;
            }
            if (framePos > lastFrame) break;
            if (nextFramePos > lastFrame) {
                nextFramePos = lastFrame;
            }
            fouAis.setFramePosition(framePos);
            boolean read = fouAis.readFrame(this.buf, 0);
            if (!read) break;
            Graphics[] gs = new Graphics[channels];
            boolean bl = false;
            while (var37_47 < channels) {
                if (rs.renderedImages != null) {
                    BufferedImage bi = rs.renderedImages[var37_47];
                    gs[var37_47] = bi.getGraphics();
                }
                ++var37_47;
            }
            boolean bl2 = false;
            while (var37_49 < height) {
                for (int ch = 0; ch < channels; ++ch) {
                    int rgbVal;
                    double scaledVal;
                    double bandIndex = maxFrequency * ((double)height - (double)var37_49) / (double)height;
                    int lowIndex = (int)bandIndex;
                    int hiIndex = lowIndex + 1;
                    double emphFactor = 0.0;
                    if (emphasisPerOctave != 0.0) {
                        emphFactor = DSPUtils.toOctaves(bandIndex / emphasisStartFreq) * emphasisPerOctave;
                    }
                    double val0 = this.buf[0][ch][lowIndex].magnitude();
                    double val1 = this.buf[0][ch][hiIndex].magnitude();
                    double val = (val1 - val0) * (bandIndex - (double)lowIndex) + val0;
                    if (rs.renderedImages == null) continue;
                    Graphics g = gs[ch];
                    double psd = 2.0 * Math.pow(val, 2.0) / (double)windowSize;
                    double psdLog = DSPUtils.toLevelInDB(psd / this.maxPsd);
                    if (bandIndex >= emphasisStartFreq) {
                        psdLog += emphFactor;
                    }
                    if (rs.max < psd) {
                        rs.max = psd;
                    }
                    if (rs.min > psd) {
                        rs.min = psd;
                    }
                    if ((scaledVal = (psdLog + dynRangeInDb) / dynRangeInDb) > 1.0) {
                        scaledVal = 1.0;
                    }
                    if (scaledVal < 0.0) {
                        scaledVal = 0.0;
                    }
                    if ((rgbVal = (int)(255.0 * scaledVal)) < 0) {
                        rgbVal = 0;
                    }
                    if (rgbVal > 255) {
                        rgbVal = 255;
                    }
                    if ((rgbVal = 255 - rgbVal) < minRgbVal) {
                        minRgbVal = rgbVal;
                    }
                    Color c = new Color(rgbVal, rgbVal, rgbVal);
                    g.setColor(c);
                    g.fillRect(pixelPos - startPixel + xOffset, (int)var37_49, 1, 1);
                }
                ++var37_49;
            }
            for (Graphics g : gs) {
                if (g == null) continue;
                g.dispose();
            }
            Thread.yield();
            lastValuePixelPos = valuePixelPos;
            renderedPixels = pixelPos - startPixel;
            Object object2 = this.threadNotify;
            synchronized (object2) {
                rs.renderedLength = renderedPixels;
                if (rs.isValid && renderedPixels % this.notifyOnPixels == 0) {
                    Request request = this.request;
                    synchronized (request) {
                        this.listener.update(new FourierRendererEvent(this, rs));
                    }
                }
                continue;
            }
        }
        fouAis.close();
        Object object3 = this.threadNotify;
        synchronized (object3) {
            if (rs.isValid) {
                rs.rendered = true;
                this.request.rendered = true;
                this.listener.update(new FourierRendererEvent(this, rs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.threadNotify;
        synchronized (object) {
            this.open = false;
            if (this.rs != null) {
                this.rs.isValid = false;
            }
            this.threadNotify.notifyAll();
        }
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.join(20000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getNotifyOnPixels() {
        return this.notifyOnPixels;
    }

    public void setNotifyOnPixels(int notifyOnPixels) {
        this.notifyOnPixels = notifyOnPixels;
    }

    public class Request {
        int fromPixel;
        int toPixel;
        int height;
        double maxFrequency;
        double framesPerPixel;
        int n;
        int windowSize;
        double dynRangeInDb;
        double emphasisPerOctave;
        double emphasisStartFreq;
        boolean calculationOfMaxRequired;
        boolean rendered;

        public Request() {
        }

        public Request(int fromPixel, int toPixel, int height, double maxFrequency, double framesPerPixel, int n, int windowSize, double dynRangeInDb, double emphasisPerOctave, double emphasisStartFreq) {
            this.fromPixel = fromPixel;
            this.toPixel = toPixel;
            this.height = height;
            this.maxFrequency = maxFrequency;
            this.framesPerPixel = framesPerPixel;
            this.n = n;
            this.windowSize = windowSize;
            this.dynRangeInDb = dynRangeInDb;
            this.emphasisPerOctave = emphasisPerOctave;
            this.emphasisStartFreq = emphasisStartFreq;
            this.calculationOfMaxRequired = true;
            this.rendered = false;
        }

        public void copy(Request r) {
            this.fromPixel = r.fromPixel;
            this.toPixel = r.toPixel;
            this.height = r.height;
            this.maxFrequency = r.maxFrequency;
            this.framesPerPixel = r.framesPerPixel;
            this.n = r.n;
            this.windowSize = r.windowSize;
            this.dynRangeInDb = r.dynRangeInDb;
            this.emphasisPerOctave = r.emphasisPerOctave;
            this.emphasisStartFreq = r.emphasisStartFreq;
            this.calculationOfMaxRequired = r.calculationOfMaxRequired;
        }

        public boolean equals(Object o) {
            boolean eqls1;
            if (o == null) {
                return false;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request r = (Request)o;
            boolean bl = eqls1 = this.fromPixel == r.fromPixel && this.toPixel == r.toPixel && this.height == r.height && this.maxFrequency == r.maxFrequency && this.framesPerPixel == r.framesPerPixel && this.n == r.n && this.windowSize == r.windowSize && this.dynRangeInDb == r.dynRangeInDb;
            return eqls1 && r.emphasisPerOctave == this.emphasisPerOctave && r.emphasisStartFreq == this.emphasisStartFreq;
        }

        public boolean isIn(Request r) {
            if (r == null) {
                return false;
            }
            if (this.framesPerPixel != r.framesPerPixel || this.n != r.n || this.maxFrequency != r.maxFrequency || this.windowSize != r.windowSize || this.dynRangeInDb != r.dynRangeInDb) {
                return false;
            }
            if (this.emphasisPerOctave != r.emphasisPerOctave || this.emphasisStartFreq != r.emphasisStartFreq) {
                return false;
            }
            if (this.fromPixel < r.fromPixel) {
                return false;
            }
            if (this.toPixel > r.toPixel) {
                return false;
            }
            return this.height == r.height;
        }

        public void checkCalculateMaxRequired(Request r) {
            boolean cr = false;
            if (r == null || this.n != r.n || this.maxFrequency != r.maxFrequency || this.windowSize != r.windowSize) {
                cr = true;
            } else if (this.emphasisPerOctave != r.emphasisPerOctave || this.emphasisStartFreq != r.emphasisStartFreq) {
                cr = true;
            }
            this.calculationOfMaxRequired = cr;
        }

        public String toString() {
            return new String("Render request from: " + this.fromPixel + ",to: " + this.toPixel + ",frames per pixel: " + this.framesPerPixel + ", N: " + this.n + ", window size: " + this.windowSize);
        }
    }

    public class RenderResult {
        public int N;
        public double[][][] values;
        public BufferedImage[] renderedImages;
        public int pixelOffset;
        public int offset;
        public int length;
        public int renderedLength;
        public boolean rendered;
        boolean isValid = true;
        public double max = Double.MIN_VALUE;
        public double min = Double.MAX_VALUE;
        public Double totalMaximum = null;

        public RenderResult(int pixels, int N, int channels) {
            this.N = N;
            this.values = new double[pixels][channels][N];
        }
    }
}

