/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.bean;

import ipsk.audio.bean.AudioPlayerBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AudioPlayerMultiURLBean
extends JPanel
implements ActionListener {
    public static final boolean DEBUG = false;
    public static final String VERSION = AudioPlayerMultiURLBean.class.getPackage().getImplementationVersion();
    private URL[] audioUrls;
    private AudioPlayerBean playerBean;
    private JComboBox<URL> urlSelectBox;

    public AudioPlayerMultiURLBean(URL[] urls) {
        super(new BorderLayout());
        this.audioUrls = urls;
        this.playerBean = new AudioPlayerBean();
        this.playerBean.setVisualizing(true);
        this.urlSelectBox = new JComboBox<URL>(urls);
        this.add((Component)this.playerBean, "Center");
        this.add(this.urlSelectBox, "South");
        this.urlSelectBox.addActionListener(this);
        this.playerBean.setURL(this.audioUrls[0]);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.playerBean.setURL((URL)this.urlSelectBox.getSelectedItem());
    }

    public void close() {
        this.playerBean.close();
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Usage: AudioPlayerMultiURLBean audioURL [audioUrl2] ...");
            System.exit(-1);
        }
        try {
            final URL[] audioUrls = new URL[args.length];
            for (int i = 0; i < audioUrls.length; ++i) {
                audioUrls[i] = new URL(args[i]);
            }
            Runnable show = new Runnable(){

                @Override
                public void run() {
                    JFrame f = new JFrame("Test audio player multi URL bean");
                    final AudioPlayerMultiURLBean aBean = new AudioPlayerMultiURLBean(audioUrls);
                    f.getContentPane().add(aBean);
                    f.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            aBean.close();
                        }

                        @Override
                        public void windowClosed(WindowEvent e) {
                            System.exit(0);
                        }
                    });
                    f.pack();
                    f.setVisible(true);
                    f.setDefaultCloseOperation(2);
                }
            };
            SwingUtilities.invokeAndWait(show);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            System.exit(-2);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            System.exit(1);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            System.exit(-3);
        }
    }
}

