/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.capture;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPluginException;
import ipsk.audio.ajs.AJSAudioSystem;
import ipsk.audio.capture.CaptureException;
import ipsk.audio.capture.CaptureHelperThread;
import ipsk.audio.capture.CaptureListener;
import ipsk.audio.capture.LineActivationTimeoutException;
import ipsk.audio.capture.PrimaryRecordTarget;
import ipsk.audio.capture.TargetDataLineInputStream2;
import ipsk.audio.capture.TargetDataLineListener;
import ipsk.audio.capture.event.CaptureCloseEvent;
import ipsk.audio.capture.event.CaptureErrorEvent;
import ipsk.audio.capture.event.CaptureEvent;
import ipsk.audio.capture.event.CaptureOpenEvent;
import ipsk.audio.capture.event.CaptureRecordedEvent;
import ipsk.audio.capture.event.CaptureRecordingFileTransitEvent;
import ipsk.audio.capture.event.CaptureStartCaptureEvent;
import ipsk.audio.capture.event.CaptureStartRecordEvent;
import ipsk.audio.capture.event.CaptureStopEvent;
import ipsk.audio.capture.event.CaptureStoppedEvent;
import ipsk.audio.capture.session.info.RecordingFile;
import ipsk.audio.capture.session.info.RecordingSegment;
import ipsk.audio.capture.session.info.RecordingSequence;
import ipsk.audio.capture.session.info.RecordingSession;
import ipsk.audio.io.InterceptorAudioInputStream;
import ipsk.audio.io.push.IAudioOutputStream;
import ipsk.audio.plugins.ChannelRoutingPlugin;
import ipsk.audio.tools.FrameUnitParser;
import ipsk.audio.utils.AudioFormatUtils;
import ipsk.io.ChannelRouting;
import ipsk.util.EventQuequeListener;
import ipsk.util.optionparser.Option;
import ipsk.util.optionparser.OptionParser;
import ipsk.util.optionparser.OptionParserException;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Timer;
import javax.xml.bind.JAXB;

public class Capture3
implements Runnable,
EventQuequeListener,
TargetDataLineListener,
ActionListener,
LineListener {
    private static final boolean DEBUG = false;
    private static final boolean THREAD_START_ON_OPEN = true;
    private static final int THREAD_PRIORITY = 10;
    private static final int IDLE_WAIT_MILLISECONDS = 1;
    private static final Float STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS = Float.valueOf(1000.0f);
    private static String[] LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES = new String[]{"ips.audio.ds.DSTargetDataLine", "ips.audio.coreaudio.CoreAudioTargetDataLine"};
    private static final boolean USE_JS_LINE_FRAME_POSITION = false;
    public static AudioFileFormat.Type DEF_AUDIO_FILE_TYPE = AudioFileFormat.Type.WAVE;
    public static AudioFormat DEF_AUDIO_FORMAT = new AudioFormat(44100.0f, 16, 2, true, false);
    public static AudioFileFormat DEF_AUDIO_FILE_FORMAT = new AudioFileFormat(AudioFileFormat.Type.WAVE, DEF_AUDIO_FORMAT, -1);
    private static final int DEF_PREFERRED_BUFFER_SIZE = 8092;
    private static final int LINE_ACTIVE_TIMEOUT_MS = 4000;
    private TargetDataLine line;
    private Mixer device;
    private InterceptorAudioInputStream ais;
    private TargetDataLineInputStream2 tdlis;
    private Timer lineActiveTimeoutTimer = null;
    private long startTimeMs = -1L;
    private File recFile;
    private String recId;
    private AudioFileFormat.Type fileType;
    private long maxFrameLength;
    private Thread thread;
    private volatile boolean running;
    private AudioFormat format;
    private AudioFormat captureFormat;
    private CaptureException formatException = null;
    private int frameSize;
    private DataLine.Info lineInfo;
    private Object streamNotify;
    private volatile State status;
    private Vector<CaptureListener> listeners;
    private volatile long streamPosOffset;
    private volatile long streamFramePosition;
    private boolean captureOnly;
    private int bufferSize;
    private int preferredBufferSize;
    private Integer preferredLineBufferSize = null;
    private Integer lineBufferSize = null;
    private HashSet<String> largeBufferSizeCapableLineClassNames;
    private int channels;
    private Float preferredLineBufferSizeMillis;
    private boolean useAWTEventThread = true;
    private boolean forceOpening = false;
    private PrimaryRecordTarget primaryRecordTarget = null;
    private Vector<IAudioOutputStream> outputStreams;
    private File tempRecFile;
    private volatile boolean writeRecordingInfo = false;
    private File recordingSessionInfoFile;
    private boolean notifyLineActivation;
    private volatile RecordingSession recordingSessionInfo;
    private volatile RecordingSequence currentRecordingSequence;
    private long sequenceFramePos;
    private ChannelRouting channelAssignment = null;
    private ChannelRoutingPlugin channelRouterPlugin = null;

    public boolean isNotifyLineActivation() {
        return this.notifyLineActivation;
    }

    public void setNotifyLineActivation(boolean notifyLineActivation) {
        this.notifyLineActivation = notifyLineActivation;
    }

    public boolean isUseTempFile() {
        return PrimaryRecordTarget.TEMP_RAW_FILE.equals((Object)this.primaryRecordTarget);
    }

    public Capture3() {
        this(null);
    }

    public Capture3(Mixer device) {
        this.device = device;
        this.preferredBufferSize = 8092;
        this.streamNotify = new Object();
        this.listeners = new Vector();
        this.outputStreams = new Vector();
        this.setAudioFileFormat(DEF_AUDIO_FILE_FORMAT);
        this.streamPosOffset = 0L;
        this.status = State.CLOSE;
        this.captureOnly = false;
        this.largeBufferSizeCapableLineClassNames = new HashSet<String>(Arrays.asList(LARGE_BUFFER_SIZE_CAPABLE_LINE_CLASS_NAMES));
    }

    public Capture3(Mixer device, File recFile, AudioFileFormat aff) {
        this(device);
        this.recFile = recFile;
        this.setAudioFileFormat(aff);
    }

    public void setAudioFileFormat(AudioFileFormat aff) {
        this.format = aff.getFormat();
        this.fileType = aff.getType();
        this.setAudioFormat(aff.getFormat());
    }

    public AudioFileFormat getAudioFileFormat() {
        return new AudioFileFormat(this.fileType, this.format, -1);
    }

    public void setAudioFormat(AudioFormat af) {
        this.format = af;
        this.frameSize = this.format.getFrameSize();
        this.channels = this.format.getChannels();
        this.updateCaptureFormat();
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public Integer getMinLineBufferSize() {
        if (this.lineInfo == null) {
            return null;
        }
        return this.lineInfo.getMinBufferSize();
    }

    public Integer getMaxLineBufferSize() {
        if (this.lineInfo == null) {
            return null;
        }
        return this.lineInfo.getMaxBufferSize();
    }

    private void updateCaptureFormat() {
        this.formatException = null;
        this.captureFormat = this.format;
        if (this.channelAssignment != null) {
            if (this.channelRouterPlugin == null) {
                this.channelRouterPlugin = new ChannelRoutingPlugin();
            }
            this.channelRouterPlugin.setChannelRouting(this.channelAssignment);
            try {
                this.channelRouterPlugin.setInputFormat(null);
                this.channelRouterPlugin.setOutputFormat(this.format);
                this.captureFormat = this.channelRouterPlugin.getInputFormat();
            }
            catch (AudioFormatNotSupportedException e) {
                this.captureFormat = null;
                this.lineInfo = null;
                this.formatException = new CaptureException("Cannot set audio format for channel routing", e);
                return;
            }
        } else {
            this.channelRouterPlugin = null;
        }
        this.lineInfo = new DataLine.Info(TargetDataLine.class, this.captureFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws CaptureException {
        if (!State.CLOSE.equals((Object)this.status)) {
            return;
        }
        int bufferFrames = this.preferredBufferSize / this.frameSize;
        this.bufferSize = bufferFrames * this.frameSize;
        if (this.line == null) {
            if (this.device == null) {
                try {
                    this.line = (TargetDataLine)AJSAudioSystem.getLine(this.lineInfo);
                }
                catch (LineUnavailableException e) {
                    throw new CaptureException("Could not get line from audio system: ", e);
                }
                catch (IllegalArgumentException e) {
                    throw new CaptureException(e);
                }
            }
            try {
                this.line = (TargetDataLine)this.device.getLine(this.lineInfo);
            }
            catch (LineUnavailableException e) {
                throw new CaptureException("Could not get line from device: ", e);
            }
            catch (IllegalArgumentException e) {
                if (this.forceOpening) {
                    Line[] lines;
                    for (Line l : lines = this.device.getTargetLines()) {
                        if (!(l instanceof TargetDataLine)) continue;
                        this.line = (TargetDataLine)l;
                        break;
                    }
                    if (this.line == null) {
                        throw new CaptureException(e);
                    }
                }
                throw new CaptureException(e);
            }
        }
        try {
            Integer requestedLinebufferSize = null;
            if (this.preferredLineBufferSize != null) {
                requestedLinebufferSize = this.preferredLineBufferSize;
            } else if (this.preferredLineBufferSizeMillis != null) {
                float preferredLimitedLineBufferSizeMillis = this.preferredLineBufferSizeMillis.floatValue();
                requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(this.captureFormat, preferredLimitedLineBufferSizeMillis / 1000.0f);
            }
            if (requestedLinebufferSize != null) {
                Class<?> clazz;
                String lineClassName;
                float requestedLineBufferSizeInMillis = AudioFormatUtils.pcmLengthFromByteLength(this.captureFormat, requestedLinebufferSize) * 1000.0f;
                if (requestedLineBufferSizeInMillis > STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() && !this.largeBufferSizeCapableLineClassNames.contains(lineClassName = (clazz = this.line.getClass()).getName())) {
                    requestedLinebufferSize = AudioFormatUtils.pcmSizeInBytesFromLength(this.captureFormat, STANDARD_MAX_LINE_BUFFER_SIZE_MILLIS.floatValue() / 1000.0f);
                }
                this.line.open(this.captureFormat, requestedLinebufferSize);
            } else {
                this.line.open(this.captureFormat);
            }
            this.line.addLineListener(this);
            this.lineBufferSize = this.line.getBufferSize();
            this.line.flush();
        }
        catch (LineUnavailableException e1) {
            throw new CaptureException("Could not open line: " + e1.getMessage(), e1);
        }
        catch (Exception e) {
            throw new CaptureException("Could not open line: " + e.getMessage(), e);
        }
        this.tdlis = new TargetDataLineInputStream2(this.line);
        if (this.notifyLineActivation) {
            this.tdlis.setListener(this);
        }
        try {
            float linebufferSizeSeconds = AudioFormatUtils.pcmLengthFromByteLength(this.captureFormat, this.lineBufferSize);
            if ((double)linebufferSizeSeconds >= 4.0) {
                this.tdlis.setMaxBufferFill(0.66);
            }
        }
        catch (AudioFormatNotSupportedException requestedLineBufferSizeInMillis) {
            // empty catch block
        }
        InputStream routedIs = this.tdlis;
        if (this.channelRouterPlugin != null) {
            AudioInputStream audioInputStream = new AudioInputStream(this.tdlis, this.captureFormat, -1L);
            try {
                routedIs = this.channelRouterPlugin.getAudioInputStream(audioInputStream);
            }
            catch (AudioPluginException e) {
                new CaptureException("Could not apply channel routing plugin: ", e);
            }
        }
        this.ais = new InterceptorAudioInputStream(routedIs, this.format, -1L);
        Vector<IAudioOutputStream> vector = this.outputStreams;
        synchronized (vector) {
            for (IAudioOutputStream aos : this.outputStreams) {
                try {
                    this.ais.addAudioOutputStream(aos);
                }
                catch (AudioFormatNotSupportedException e) {
                    new CaptureException("Capture listener stream: ", e);
                }
            }
        }
        if (this.isUseTempFile()) {
            try {
                this.tempRecFile = File.createTempFile(this.getClass().getName(), ".raw");
                this.tempRecFile.deleteOnExit();
            }
            catch (IOException iOException) {
                throw new CaptureException(iOException);
            }
        }
        Object object = this.streamNotify;
        synchronized (object) {
            this.running = true;
            this.status = State.STOP;
            this.syncPosition();
        }
        if (System.getProperty("debug.sinustest") != null) {
            DataLine.Info info = (DataLine.Info)this.line.getLineInfo();
        }
        if (this.thread == null) {
            this.thread = new Thread((Runnable)this, "Audio-Capture");
            this.thread.setPriority(10);
            this.thread.start();
        }
        if (this.writeRecordingInfo) {
            this.recordingSessionInfo = this.recordingSessionInfoFile != null && this.recordingSessionInfoFile.exists() ? (RecordingSession)JAXB.unmarshal((File)this.recordingSessionInfoFile, RecordingSession.class) : new RecordingSession();
        }
        if (this.notifyLineActivation && this.lineActiveTimeoutTimer == null) {
            this.lineActiveTimeoutTimer = new Timer(4000, this);
            this.lineActiveTimeoutTimer.setRepeats(false);
        }
        this.sendEventAndWait(new CaptureOpenEvent(this));
    }

    private void sendEventAndWait(EventObject eo) {
        if (!this.useAWTEventThread || EventQueue.isDispatchThread()) {
            this.update(eo);
        } else {
            EventSender es = new EventSender(eo);
            try {
                EventQueue.invokeAndWait(es);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void sendEvent(EventObject eo) {
        if (!this.useAWTEventThread || EventQueue.isDispatchThread()) {
            this.update(eo);
        } else {
            EventSender es = new EventSender(eo);
            EventQueue.invokeLater(es);
        }
    }

    private boolean isRunning() {
        return State.RECORD.equals((Object)this.status) || State.RECORD_INIT.equals((Object)this.status) || State.CAPTURE.equals((Object)this.status) || State.TARGET_CHANGE.equals((Object)this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.streamNotify;
        synchronized (object) {
            if (!this.isRunning()) {
                try {
                    this.tdlis.resetStream();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.syncPosition();
                this.line.start();
                this.startTimeMs = System.currentTimeMillis();
                this.status = this.captureOnly ? State.CAPTURE : State.RECORD_INIT;
                this.streamNotify.notifyAll();
                if (this.notifyLineActivation && this.lineActiveTimeoutTimer != null) {
                    this.lineActiveTimeoutTimer.start();
                }
                if (State.CAPTURE.equals((Object)this.status)) {
                    this.sendEventAndWait(new CaptureStartCaptureEvent(this));
                } else {
                    this.sendEventAndWait(new CaptureStartRecordEvent(this));
                }
            }
        }
    }

    public long getMaxFrameLength() {
        return this.maxFrameLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws CaptureException {
        Object object = this.streamNotify;
        synchronized (object) {
            if (!(State.STOPPING.equals((Object)this.status) || State.STOP.equals((Object)this.status) || State.CLOSE.equals((Object)this.status))) {
                State oldStatus = this.status;
                this.status = State.STOPPING;
                this.tdlis.stop();
                if (this.line != null) {
                    this.line.stop();
                }
                this.status = State.STOPPING;
                if (State.CAPTURE.equals((Object)oldStatus)) {
                    this.sendEventAndWait(new CaptureStoppedEvent(this));
                }
            }
        }
    }

    public void close() throws CaptureException {
        this._close();
        if (this.line != null) {
            this.line.removeLineListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _close() throws CaptureException {
        Object object = this.streamNotify;
        synchronized (object) {
            if (State.CLOSE.equals((Object)this.status) || State.CLOSING.equals((Object)this.status)) {
                return;
            }
            this.stop();
            this.running = false;
            this.streamNotify.notifyAll();
        }
        this.status = State.CLOSING;
        if (this.thread != null) {
            try {
                this.thread.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        if (this.lineActiveTimeoutTimer != null) {
            this.lineActiveTimeoutTimer.stop();
            this.lineActiveTimeoutTimer = null;
        }
        object = this.streamNotify;
        synchronized (object) {
            try {
                if (this.ais != null) {
                    this.ais.close();
                }
            }
            catch (IOException e) {
                throw new CaptureException(e);
            }
            finally {
                if (this.line != null) {
                    this.line.flush();
                    this.line.close();
                }
                this.line = null;
                if (this.isUseTempFile() && this.tempRecFile != null) {
                    this.tempRecFile.delete();
                }
                if (this.writeRecordingInfo) {
                    if (this.currentRecordingSequence != null) {
                        this.currentRecordingSequence.setFrameLength(this.sequenceFramePos);
                        this.recordingSessionInfo.getRecordingSequenceList().add(this.currentRecordingSequence);
                    }
                    JAXB.marshal((Object)this.recordingSessionInfo, (File)this.recordingSessionInfoFile);
                }
                this.status = State.CLOSE;
                this.sendEventAndWait(new CaptureCloseEvent(this));
            }
        }
    }

    public long getFramePosition() {
        if (this.tdlis == null) {
            return 0L;
        }
        return this.tdlis.getFramePosition();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] buffer = new byte[this.bufferSize];
        while (this.running) {
            while (this.running && !this.isRecording() && !this.isCapturing()) {
                Object object = this.streamNotify;
                synchronized (object) {
                    try {
                        this.streamNotify.wait(1L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            IOException exception = null;
            while (State.CAPTURE.equals((Object)this.status)) {
                if (this.writeRecordingInfo && this.currentRecordingSequence != null) {
                    this.currentRecordingSequence.setFrameLength(this.sequenceFramePos);
                    this.recordingSessionInfo.getRecordingSequenceList().add(this.currentRecordingSequence);
                    this.currentRecordingSequence = null;
                }
                try {
                    int read = this.ais.read(buffer);
                    if (read == 0) {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (read >= 0) continue;
                    break;
                }
                catch (IOException e) {
                    System.err.println(e.getLocalizedMessage());
                    this.sendEvent(new CaptureErrorEvent(this, e));
                    return;
                }
            }
            if (State.RECORD_INIT.equals((Object)this.status)) {
                this.syncPosition();
                this.tdlis.resetStream();
                this.currentRecordingSequence = new RecordingSequence();
                this.sequenceFramePos = 0L;
                this.currentRecordingSequence.setStartFrame(this.sequenceFramePos);
                this.status = State.RECORD;
            }
            if (!State.RECORD.equals((Object)this.status)) continue;
            this.syncPosition();
            if (this.isUseTempFile()) {
                FileOutputStream tmpOs;
                block54: {
                    tmpOs = null;
                    try {
                        tmpOs = new FileOutputStream(this.tempRecFile);
                        int read = 0;
                        while ((read = this.ais.read(buffer)) != -1) {
                            tmpOs.write(buffer, 0, read);
                        }
                    }
                    catch (IOException e) {
                        exception = e;
                    }
                    if (tmpOs != null) {
                        try {
                            tmpOs.close();
                        }
                        catch (IOException e1) {
                            tmpOs = null;
                            if (exception != null) break block54;
                            exception = e1;
                        }
                    }
                }
                if (!(State.CAPTURE.equals((Object)this.status) || State.STOPPING.equals((Object)this.status) || State.STOP.equals((Object)this.status) || State.CLOSE.equals((Object)this.status))) {
                    this.status = State.STOPPING;
                    if (this.line != null) {
                        this.line.stop();
                    }
                    this.status = State.STOP;
                }
                if (exception != null) {
                    this.sendEvent(new CaptureErrorEvent(this, exception));
                    System.err.println(exception.getLocalizedMessage());
                    return;
                }
                if (tmpOs != null) {
                    CaptureHelperThread captureHelperThread;
                    block55: {
                        FileInputStream tmpIs = null;
                        captureHelperThread = null;
                        try {
                            tmpIs = new FileInputStream(this.tempRecFile);
                            int frameSize = this.format.getFrameSize();
                            long fileLength = this.tempRecFile.length();
                            long frameLength = fileLength / (long)frameSize;
                            if (State.CAPTURE.equals((Object)this.status)) {
                                captureHelperThread = new CaptureHelperThread(this.ais, this.bufferSize);
                                captureHelperThread.start();
                            }
                            AudioInputStream tmpAis = new AudioInputStream(tmpIs, this.format, frameLength);
                            AudioSystem.write(tmpAis, this.fileType, this.recFile);
                        }
                        catch (IOException e) {
                            exception = e;
                        }
                        if (tmpIs != null) {
                            try {
                                tmpIs.close();
                            }
                            catch (IOException e) {
                                if (exception != null) break block55;
                                exception = e;
                            }
                        }
                    }
                    if (captureHelperThread != null) {
                        captureHelperThread.close();
                    }
                    if (exception != null) {
                        this.sendEvent(new CaptureErrorEvent(this, exception));
                        System.err.println(exception.getLocalizedMessage());
                        return;
                    }
                }
            } else {
                long startFramePos = this.tdlis.getFramePosition();
                RecordingFile rfInfo = null;
                RecordingSegment rSeg = null;
                try {
                    String rrecId;
                    File rrecFile;
                    Object frameLength = this.streamNotify;
                    synchronized (frameLength) {
                        rrecFile = this.recFile;
                        rrecId = this.recId;
                        if (this.writeRecordingInfo && this.currentRecordingSequence != null) {
                            if (rrecFile.exists()) {
                                this.recordingSessionInfo.removeRecordingFile(rrecFile);
                            }
                            rfInfo = new RecordingFile();
                            rfInfo.setFile(new File(rrecFile.getName()));
                            rSeg = new RecordingSegment();
                            rSeg.setStartFrame(startFramePos);
                            rSeg.setId(this.recId);
                            rSeg.setStartTime(new Date());
                        }
                    }
                    AudioSystem.write((AudioInputStream)this.ais, this.fileType, rrecFile);
                    if (rfInfo != null) {
                        this.sequenceFramePos = this.tdlis.getFramePosition();
                        rSeg.setFrameLength(this.sequenceFramePos - startFramePos);
                        rfInfo.setLastModified(new Date(rrecFile.lastModified()));
                        rfInfo.getRecordingSegmentList().add(rSeg);
                        if (rrecId != null) {
                            rSeg.setId(rrecId);
                        }
                        this.currentRecordingSequence.getRecordingFileList().add(rfInfo);
                    }
                }
                catch (IOException e) {
                    try {
                        File tmp = File.createTempFile("speechrecorder", this.fileType.getExtension());
                        tmp.deleteOnExit();
                        AudioInputStream tmpAis = AudioSystem.getAudioInputStream(this.recFile);
                        AudioSystem.write(tmpAis, this.fileType, tmp);
                        tmpAis.close();
                        AudioInputStream tmpAis2 = AudioSystem.getAudioInputStream(tmp);
                        AudioSystem.write(tmpAis2, this.fileType, this.recFile);
                        tmpAis2.close();
                        tmp.delete();
                    }
                    catch (Exception repairException) {
                        this.recFile.delete();
                    }
                    this.sendEvent(new CaptureErrorEvent(this, e));
                    System.err.println(e.getLocalizedMessage());
                    return;
                }
                finally {
                    if (State.TARGET_CHANGE.equals((Object)this.status)) {
                        this.ais.setInterrupted(false);
                    } else if (!(State.CAPTURE.equals((Object)this.status) || State.STOPPING.equals((Object)this.status) || State.STOP.equals((Object)this.status) || State.CLOSE.equals((Object)this.status))) {
                        this.status = State.STOPPING;
                        if (this.line != null) {
                            this.line.stop();
                        }
                        this.status = State.STOP;
                    }
                }
            }
            if (State.TARGET_CHANGE.equals((Object)this.status)) {
                this.sendEvent(new CaptureRecordingFileTransitEvent(this));
                this.status = State.RECORD;
                continue;
            }
            this.sendEvent(new CaptureRecordedEvent(this));
        }
    }

    private void syncPosition() {
        if (this.line == null) {
            this.streamPosOffset = 0L;
            return;
        }
        this.streamPosOffset = this.line.getLongFramePosition() - this.streamFramePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCaptureListener(CaptureListener pl) {
        Vector<CaptureListener> vector = this.listeners;
        synchronized (vector) {
            if (pl != null && !this.listeners.contains(pl)) {
                this.listeners.addElement(pl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCaptureListener(CaptureListener pl) {
        Vector<CaptureListener> vector = this.listeners;
        synchronized (vector) {
            if (pl != null) {
                this.listeners.removeElement(pl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAudioOutputStream(IAudioOutputStream aos) {
        Vector<IAudioOutputStream> vector = this.outputStreams;
        synchronized (vector) {
            if (aos != null && !this.outputStreams.contains(aos)) {
                this.outputStreams.addElement(aos);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAudioOutputStream(IAudioOutputStream aos) {
        Vector<IAudioOutputStream> vector = this.outputStreams;
        synchronized (vector) {
            if (aos != null) {
                this.outputStreams.removeElement(aos);
                if (this.ais != null) {
                    this.ais.removeOutputStream(aos);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(EventObject eventObject) {
        Vector<CaptureListener> vector = this.listeners;
        synchronized (vector) {
            for (CaptureListener listener : this.listeners) {
                listener.update((CaptureEvent)eventObject);
            }
        }
    }

    public boolean isRecording() {
        return State.RECORD.equals((Object)this.status) || State.RECORD_INIT.equals((Object)this.status) || State.TARGET_CHANGE.equals((Object)this.status);
    }

    public boolean isCapturing() {
        return State.CAPTURE.equals((Object)this.status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordingFile(File file) {
        Object object = this.streamNotify;
        synchronized (object) {
            this.recFile = file;
            if (State.RECORD.equals((Object)this.status)) {
                if (!PrimaryRecordTarget.DIRECT.equals((Object)this.primaryRecordTarget)) {
                    throw new IllegalArgumentException("Change recording file during capture is only allowed for direct recording files (not temporary files)");
                }
                this.status = State.TARGET_CHANGE;
                this.ais.setInterrupted(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordingItem(File file, String recId) {
        Object object = this.streamNotify;
        synchronized (object) {
            this.recId = recId;
            this.recFile = file;
            if (State.RECORD.equals((Object)this.status)) {
                this.status = State.TARGET_CHANGE;
                this.ais.setInterrupted(true);
            }
        }
    }

    public File getRecordingFile() {
        return this.recFile;
    }

    public void setMixer(Mixer newCaptureMixer) {
        this.device = newCaptureMixer;
    }

    public boolean isCaptureOnly() {
        return this.captureOnly;
    }

    public void setCaptureOnly(boolean captureOnly) {
        this.captureOnly = captureOnly;
        if (State.CAPTURE.equals((Object)this.status) && !captureOnly) {
            this.status = State.RECORD_INIT;
            this.sendEventAndWait(new CaptureStartRecordEvent(this));
        } else if ((State.RECORD.equals((Object)this.status) || State.RECORD_INIT.equals((Object)this.status)) && captureOnly) {
            this.status = State.CAPTURE;
            this.tdlis.flushAndCloseStream();
            this.sendEventAndWait(new CaptureStartCaptureEvent(this));
        }
    }

    public Integer getPreferredBufferSize() {
        return this.preferredBufferSize;
    }

    public void setPreferredBufferSize(int preferredBufferSize) {
        this.preferredBufferSize = preferredBufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Integer getPreferredLineBufferSize() {
        return this.preferredLineBufferSize;
    }

    public void setPreferredLineBufferSize(Integer preferredLineBufferSize) {
        this.preferredLineBufferSizeMillis = null;
        this.preferredLineBufferSize = preferredLineBufferSize;
    }

    public Integer getLineBufferSize() {
        return this.lineBufferSize;
    }

    public Float getLineBufferSizeSeconds() {
        Integer lineBufferSize = this.getLineBufferSize();
        if (lineBufferSize == null || this.format == null) {
            return null;
        }
        float framerate = this.format.getFrameRate();
        if (framerate == -1.0f) {
            return null;
        }
        int frameSize = this.format.getFrameSize();
        if (frameSize == -1) {
            return null;
        }
        int lineBufferFrames = lineBufferSize / frameSize;
        return Float.valueOf((float)lineBufferFrames / framerate);
    }

    public boolean isOpen() {
        return !State.CLOSE.equals((Object)this.status);
    }

    public Float getPreferredLineBufferSizeMillis() {
        return this.preferredLineBufferSizeMillis;
    }

    public void setPreferredLineBufferSizeMillis(Float preferredLineBufferSizeMillis) {
        this.preferredLineBufferSize = null;
        this.preferredLineBufferSizeMillis = preferredLineBufferSizeMillis;
    }

    public boolean isUseAWTEventThread() {
        return this.useAWTEventThread;
    }

    public void setUseAWTEventThread(boolean useAWTEventThread) {
        this.useAWTEventThread = useAWTEventThread;
    }

    public void setMaxFrameLength(long maxFrameLength) {
        this.maxFrameLength = maxFrameLength;
    }

    private static void printUsage() {
        System.out.println("Audio recorder version " + Capture3.class.getPackage().getImplementationVersion() + "\nRecords audio from standard audio input device to recordingfilename.\nUsage: java " + Capture3.class.getName() + " [-length recordingtime] recordingfilename\nWithout option the program records until the program terminates (by Ctrl-C)\nOptions:\n       -length recordingtime:\n       Stop recording after recordingtime.\n       \n       -overwrite\n       force  overwrite existing recording file.\n\nNote: Recording time value must can be given in audio frames (without unit)\n      in seconds (with unit \"s\") or in milliseconds (unit \"ms\").\n      units must be directly appended to the value (no blank)Examples:\njava " + Capture3.class.getName() + " record.wav\nRecords to file record.wav. Recording can be stopped by Ctrl-C.\njava " + Capture3.class.getName() + " -length 44100 record.wav\nRecords 44100 frames (samples) to file record.wav\njava " + Capture3.class.getName() + " -v -overwrite -length 1s record.wav\nRecords 1 second to file record.wav, overrides record.wav if it exists and shows verbose messages\n");
    }

    public boolean isForceOpening() {
        return this.forceOpening;
    }

    public void setForceOpening(boolean forceOpening) {
        this.forceOpening = forceOpening;
    }

    public PrimaryRecordTarget getPrimaryRecordTarget() {
        return this.primaryRecordTarget;
    }

    public void setPrimaryRecordTarget(PrimaryRecordTarget primaryRecordTarget) {
        this.primaryRecordTarget = primaryRecordTarget;
    }

    public File getRecordingSessionInfoFile() {
        return this.recordingSessionInfoFile;
    }

    public void setRecordingSessionInfoFile(File recordingSessionInfoFile) {
        this.recordingSessionInfoFile = recordingSessionInfoFile;
    }

    public boolean isWriteRecordingInfo() {
        return this.writeRecordingInfo;
    }

    public void setWriteRecordingInfo(boolean writeRecordingInfo) {
        this.writeRecordingInfo = writeRecordingInfo;
    }

    public String getRecId() {
        return this.recId;
    }

    public void setRecId(String recId) {
        this.recId = recId;
    }

    public ChannelRouting getChannelRouting() {
        return this.channelAssignment;
    }

    public void setChannelRouting(ChannelRouting channelRouting) {
        this.channelAssignment = channelRouting;
        this.updateCaptureFormat();
    }

    public static void main(String[] args) {
        OptionParser op = new OptionParser();
        Option overwriteOption = new Option("overwrite");
        Option recTimeOption = new Option("length", null);
        Option verboseOption = new Option("v");
        Option helpOption = new Option("h");
        op.addOption(verboseOption);
        op.addOption(helpOption);
        op.addOption(recTimeOption);
        op.addOption(overwriteOption);
        try {
            op.parse(args);
        }
        catch (OptionParserException e) {
            System.err.println(e.getLocalizedMessage());
            System.exit(-1);
        }
        if (helpOption.isSet()) {
            Capture3.printUsage();
            System.exit(0);
        }
        final boolean verbose = verboseOption.isSet();
        Capture3 c = new Capture3();
        c.setUseAWTEventThread(false);
        String recordingTime = null;
        File recFile = null;
        boolean overwrite = false;
        overwrite = overwriteOption.isSet();
        recordingTime = recTimeOption.getParam();
        String[] params = op.getParams();
        if (params.length == 0) {
            Capture3.printUsage();
            System.exit(-1);
        } else if (params.length == 1) {
            try {
                URL url = new URL(params[0]);
                String urlProto = url.getProtocol();
                if (!urlProto.equalsIgnoreCase("file")) {
                    System.err.println("Only file protocol URL's are supported");
                    System.exit(-1);
                }
                recFile = new File(url.toURI().getPath());
            }
            catch (MalformedURLException e1) {
                recFile = new File(params[0]);
            }
            catch (URISyntaxException e) {
                recFile = new File(params[0]);
            }
        }
        if (verbose) {
            System.out.println("Audio recorder version " + Capture3.class.getPackage().getImplementationVersion() + "\n");
        }
        if (!overwrite && recFile.exists()) {
            System.err.println("Recording file exists. Exiting.\nUse overwrite option to force overwrite.");
            System.exit(-1);
        }
        c.setRecordingFile(recFile);
        CaptureListener cl = null;
        Shutdown shutDown = new Shutdown(c, verbose);
        cl = new CaptureListener(){

            @Override
            public void update(CaptureEvent captureEvent) {
                if (captureEvent instanceof CaptureStopEvent && verbose) {
                    System.out.println("Capture stopped.");
                }
                if (captureEvent instanceof CaptureCloseEvent && verbose) {
                    System.out.println("Capture closed.");
                }
            }
        };
        c.addCaptureListener(cl);
        Runtime.getRuntime().addShutdownHook(shutDown);
        if (recordingTime != null) {
            FrameUnitParser fup = new FrameUnitParser(c.getAudioFormat().getFrameRate());
            long frameLength = fup.parseFrameUnitString(recordingTime);
            c.setMaxFrameLength(frameLength);
        }
        try {
            c.open();
            if (verbose) {
                System.out.println("Capture open.");
            }
        }
        catch (CaptureException e1) {
            System.err.println("Could not open capture engine:");
            e1.printStackTrace();
            System.exit(-1);
        }
        c.start();
        if (verbose) {
            System.out.println("Capture started.");
        }
        if (verbose && !recTimeOption.isSet()) {
            System.out.println("Press Ctrl-C to stop.");
        }
    }

    @Override
    public void update(CaptureEvent targetDataLineEvent) {
        this.lineActiveTimeoutTimer.stop();
        this.sendEvent(targetDataLineEvent);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.lineActiveTimeoutTimer) {
            LineActivationTimeoutException ex = new LineActivationTimeoutException("Waited 4000 for activation of audio line!");
            CaptureErrorEvent ce = new CaptureErrorEvent(this, ex);
            this.sendEvent(ce);
        }
    }

    @Override
    public void update(LineEvent event) {
        LineEvent.Type type = event.getType();
        if (LineEvent.Type.STOP.equals(type)) {
            boolean stoppable;
            boolean bl = stoppable = State.STOPPING.compareTo(this.status) < 0;
            if (stoppable) {
                try {
                    this.stop();
                }
                catch (CaptureException e) {
                    e.printStackTrace();
                }
            }
        } else if (LineEvent.Type.CLOSE.equals(type)) {
            boolean closeable;
            boolean bl = closeable = State.CLOSING.compareTo(this.status) < 0;
            if (closeable) {
                try {
                    this._close();
                }
                catch (CaptureException e) {
                    e.printStackTrace();
                }
                if (this.line != null) {
                    this.line.removeLineListener(this);
                }
            }
        }
    }

    private static class Shutdown
    extends Thread {
        private Capture3 c;
        private boolean verbose;

        public Shutdown(Capture3 c, boolean verbose) {
            this.c = c;
            this.verbose = verbose;
        }

        @Override
        public void run() {
            block5: {
                if (this.verbose) {
                    System.out.println("Shutdown ...");
                }
                try {
                    if (this.c.isOpen()) {
                        if (this.verbose) {
                            System.out.println("Capture closing...");
                        }
                        this.c.close();
                    }
                }
                catch (CaptureException e) {
                    System.err.println("Could not close capture engine !");
                    if (!this.verbose) break block5;
                    e.printStackTrace();
                }
            }
        }
    }

    private class EventSender
    implements Runnable {
        private final EventObject eo;

        public EventSender(EventObject eo) {
            this.eo = eo;
        }

        @Override
        public void run() {
            Capture3.this.update(this.eo);
        }
    }

    public static enum State {
        CLOSE,
        CLOSING,
        STOPPING,
        STOP,
        CAPTURE,
        RECORD_INIT,
        RECORD,
        TARGET_CHANGE,
        PAUSE,
        ERROR;

    }

    public class RecordingFileInfo
    extends RecordingInfo {
        private String filename;
    }

    public class RecordingFileSequenceInfo
    extends RecordingInfo {
        private List<RecordingFileInfo> recordingSequence;
    }

    public class RecordingInfo {
        private long startFrame;
        private long frameLength;
    }

    public class RecordingInfos {
        private List<RecordingInfo> recordingInfos;
    }
}

