/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.capture;

import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class CaptureHelperThread
extends Thread {
    private boolean DEBUG = false;
    private volatile AudioInputStream audioInputStream;
    private volatile boolean running = true;
    private byte[] buf;

    public CaptureHelperThread(AudioInputStream audioInputStream, int bufferSize) {
        super("Idle capture thread");
        this.audioInputStream = audioInputStream;
        this.buf = new byte[bufferSize];
    }

    public AudioInputStream getAudioInputStream() {
        return this.audioInputStream;
    }

    @Override
    public void run() {
        int read = 0;
        while (this.running) {
            if (this.audioInputStream == null) continue;
            try {
                read = this.audioInputStream.read(this.buf);
                if (this.DEBUG) {
                    System.out.println("Dummy capture read " + read + " bytes (helper thread");
                }
                if (read == 0) {
                    Thread.sleep(50L);
                }
                if (read != -1) continue;
                this.running = false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void close() {
        this.running = false;
        this.interrupt();
        try {
            this.join();
            if (this.DEBUG) {
                System.out.println("Dummy read thread joined");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

