/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import javax.sound.sampled.AudioFormat;

public class AudioClipDSPInfo {
    public static double LN = 20.0 / Math.log(10.0);
    protected AudioFormat audioFormat = null;
    protected double[] minAmplitudes;
    protected double[] maxAmplitudes;
    private Double[] minSegmentalMeanPower = null;
    private double[] maxPower = null;
    protected long frameLength = -1L;

    public long getFrameLength() {
        return this.frameLength;
    }

    public void setFrameLength(long frameLength) {
        this.frameLength = frameLength;
    }

    public double getFrameLengthInSeconds() {
        return (double)this.frameLength / (double)this.audioFormat.getFrameRate();
    }

    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    public void setAudioFormat(AudioFormat audioFormat) {
        this.audioFormat = audioFormat;
    }

    public double getNormalizedMaxPeakLevelOfAllChannels() {
        double[] maxPeakLevels = this.getNormalizedMaxPeakLevels();
        double maxPeakLevel = 0.0;
        for (double maxChPeakLevel : maxPeakLevels) {
            if (!(maxPeakLevel < maxChPeakLevel)) continue;
            maxPeakLevel = maxChPeakLevel;
        }
        return maxPeakLevel;
    }

    public double[] getNormalizedMaxPeakLevels() {
        int chs = this.audioFormat.getChannels();
        double[] maxNormPeakLevels = new double[chs];
        for (int c = 0; c < this.audioFormat.getChannels(); ++c) {
            maxNormPeakLevels[c] = 2.0 * Math.max(Math.abs(this.minAmplitudes[c]), Math.abs(this.maxAmplitudes[c]));
        }
        return maxNormPeakLevels;
    }

    public double[] getMaxPeakLevels() {
        int chs = this.audioFormat.getChannels();
        double[] maxPeakLevels = new double[chs];
        for (int c = 0; c < this.audioFormat.getChannels(); ++c) {
            maxPeakLevels[c] = Math.max(Math.abs(this.minAmplitudes[c]), Math.abs(this.maxAmplitudes[c]));
        }
        return maxPeakLevels;
    }

    public double[] getMinPeakLevels() {
        int chs = this.audioFormat.getChannels();
        double[] minPeakLevels = new double[chs];
        for (int c = 0; c < chs; ++c) {
            minPeakLevels[c] = Math.min(Math.abs(this.minAmplitudes[c]), Math.abs(this.maxAmplitudes[c]));
        }
        return minPeakLevels;
    }

    public double[] getMinNormalizedAmplitudes() {
        double[] mnas = null;
        if (this.minAmplitudes != null) {
            mnas = new double[this.minAmplitudes.length];
            for (int i = 0; i < mnas.length; ++i) {
                mnas[i] = this.minAmplitudes[i] * 2.0;
            }
        }
        return mnas;
    }

    public double[] getMaxNormalizedAmplitudes() {
        double[] mnas = null;
        if (this.maxAmplitudes != null) {
            mnas = new double[this.maxAmplitudes.length];
            for (int i = 0; i < mnas.length; ++i) {
                mnas[i] = this.maxAmplitudes[i] * 2.0;
            }
        }
        return mnas;
    }

    public double[] getMinAmplitudes() {
        return this.minAmplitudes;
    }

    public void setMinAmplitudes(double[] minAmplitudes) {
        this.minAmplitudes = minAmplitudes;
    }

    public double[] getMaxAmplitudes() {
        return this.maxAmplitudes;
    }

    public void setMaxAmplitudes(double[] maxAmplitudes) {
        this.maxAmplitudes = maxAmplitudes;
    }

    public double[] getMaxLogarithmLevels() {
        int chs = this.maxAmplitudes.length;
        double[] maxLogLevels = new double[chs];
        for (int c = 0; c < chs; ++c) {
            maxLogLevels[c] = LN * Math.log(Math.abs(2.0 * this.maxAmplitudes[c]));
        }
        return maxLogLevels;
    }

    public double[] getMinLogarithmLevels() {
        int chs = this.minAmplitudes.length;
        double[] minLogLevels = new double[chs];
        for (int c = 0; c < chs; ++c) {
            minLogLevels[c] = LN * Math.log(Math.abs(2.0 * this.minAmplitudes[c]));
        }
        return minLogLevels;
    }

    public Double[] getEstimatedLogarithmSignalToBackgroundNoiseRatio() {
        Double[] logSNR = null;
        Double[] snrRatio = this.getEstimatedSignalToBackgroundNoiseRatio();
        if (snrRatio != null) {
            logSNR = new Double[snrRatio.length];
            for (int c = 0; c < snrRatio.length; ++c) {
                if (snrRatio[c] == null) continue;
                logSNR[c] = 10.0 * Math.log10(snrRatio[c]);
            }
        }
        return logSNR;
    }

    public Double[] getEstimatedSignalToBackgroundNoiseRatio() {
        Double[] snrs = null;
        if (this.maxPower != null && this.minSegmentalMeanPower != null) {
            snrs = new Double[this.minSegmentalMeanPower.length];
            for (int c = 0; c < snrs.length; ++c) {
                if (this.minSegmentalMeanPower[c] == null || !(this.maxPower[c] > this.minSegmentalMeanPower[c])) continue;
                snrs[c] = (this.maxPower[c] - this.minSegmentalMeanPower[c]) / this.minSegmentalMeanPower[c];
            }
        }
        return snrs;
    }

    public Double[] getMinSegmentalMeanPower() {
        return this.minSegmentalMeanPower;
    }

    public void setMinSegmentalMeanPower(Double[] minSegmentalMeanPower) {
        this.minSegmentalMeanPower = minSegmentalMeanPower;
    }

    public double[] getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(double[] maxPower) {
        this.maxPower = maxPower;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Audio clip DSP info:\n");
        sb.append("Audio format: " + this.audioFormat + "\n");
        int channels = this.audioFormat.getChannels();
        for (int i = 0; i < channels; ++i) {
            sb.append("Channel " + Integer.toString(i) + ":\n");
            sb.append("Max amplitude:\n");
            sb.append(this.maxAmplitudes[i] * 2.0);
        }
        return sb.toString();
    }
}

