/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.audio.io.push.FloatAudioOutputStream;
import ipsk.audio.io.push.IAudioOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;

public class AudioOutputStreamFloatConverter
implements IAudioOutputStream {
    private static final boolean DEBUG = false;
    private byte[] oneByteBuffer = new byte[1];
    private double[][] normBuffer;
    private int frameSize;
    private int channels;
    private AudioFormat audioFormat;
    private AudioFrameProcessor bufferProcessor;
    private Vector<FloatAudioOutputStream> floatOutputStreams = new Vector();

    public void flush() throws IOException {
        for (FloatAudioOutputStream faos : this.floatOutputStreams) {
            faos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] b, int off, int len) throws IOException {
        if (len % this.frameSize > 0) {
            throw new IOException("Audio output stream out of frame constraints.");
        }
        int frames = len / this.frameSize;
        if (this.normBuffer.length < frames) {
            this.normBuffer = new double[frames][this.channels];
        }
        this.bufferProcessor.getNormalizedInterleavedValues(b, off, frames, this.normBuffer, 0);
        if (frames > 0) {
            Vector<FloatAudioOutputStream> vector = this.floatOutputStreams;
            synchronized (vector) {
                for (FloatAudioOutputStream faos : this.floatOutputStreams) {
                    faos.write(this.normBuffer, 0, frames);
                }
            }
        }
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    public void write(int b) throws IOException {
        this.oneByteBuffer[0] = (byte)(b & 0xFF);
        this.write(this.oneByteBuffer);
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.audioFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudioFormat(AudioFormat audioFormat) throws AudioFormatNotSupportedException {
        this.audioFormat = audioFormat;
        this.frameSize = audioFormat.getFrameSize();
        this.channels = audioFormat.getChannels();
        this.bufferProcessor = new AudioFrameProcessor(audioFormat);
        this.normBuffer = new double[1][this.channels];
        Vector<FloatAudioOutputStream> vector = this.floatOutputStreams;
        synchronized (vector) {
            for (FloatAudioOutputStream faos : this.floatOutputStreams) {
                faos.setChannels(this.channels);
                faos.setAudioFormat(audioFormat);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Vector<FloatAudioOutputStream> vector = this.floatOutputStreams;
        synchronized (vector) {
            for (FloatAudioOutputStream faos : this.floatOutputStreams) {
                faos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFloatAudioOutputStream(FloatAudioOutputStream floatAudioOutputStream) {
        Vector<FloatAudioOutputStream> vector = this.floatOutputStreams;
        synchronized (vector) {
            if (floatAudioOutputStream != null && !this.floatOutputStreams.contains(floatAudioOutputStream)) {
                AudioFormat af = this.getAudioFormat();
                if (af != null) {
                    floatAudioOutputStream.setAudioFormat(af);
                }
                this.floatOutputStreams.addElement(floatAudioOutputStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFloatAudioOutputStream(FloatAudioOutputStream floatAudioOutputStream) {
        Vector<FloatAudioOutputStream> vector = this.floatOutputStreams;
        synchronized (vector) {
            if (floatAudioOutputStream != null) {
                this.floatOutputStreams.removeElement(floatAudioOutputStream);
            }
        }
    }
}

