/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class FloatAudioInputStream
implements InterleavedFloatStream {
    private static int DEFAULT_BUF_SIZE_IN_FRAMES = 512;
    private AudioInputStream srcAudioInputStream;
    private byte[] buffer;
    private int frameSize;
    private int channels;
    private boolean useReadOnSkipException;
    private AudioFrameProcessor bufferProcessor;

    public FloatAudioInputStream(AudioInputStream srcAudioInputStream) throws AudioFormatNotSupportedException {
        this.srcAudioInputStream = srcAudioInputStream;
        AudioFormat audioFormat = srcAudioInputStream.getFormat();
        this.frameSize = audioFormat.getFrameSize();
        this.channels = audioFormat.getChannels();
        this.buffer = new byte[0];
        this.bufferProcessor = new AudioFrameProcessor(audioFormat);
    }

    public void close() throws IOException {
        this.srcAudioInputStream.close();
    }

    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    public long getFrameLength() {
        return this.srcAudioInputStream.getFrameLength();
    }

    public int read(double[][] normBuf, int frameOffset, int frames) throws IOException {
        int read;
        int bytesToRead = this.frameSize * frames;
        if (this.buffer.length < bytesToRead) {
            this.buffer = new byte[bytesToRead];
        }
        if ((read = this.srcAudioInputStream.read(this.buffer, 0, bytesToRead)) == -1) {
            return read;
        }
        if (read % this.frameSize != 0) {
            throw new IOException("Audio stream out of frame constraints.");
        }
        int readFrames = read / this.frameSize;
        for (int i = 0; i < readFrames; ++i) {
            this.bufferProcessor.getDoubleValues(this.buffer, i * this.frameSize, normBuf[frameOffset + i]);
        }
        return readFrames;
    }

    public int read(float[][] normBuf, int frameOffset, int frames) throws IOException {
        int read;
        int bytesToRead = this.frameSize * frames;
        if (this.buffer.length < bytesToRead) {
            this.buffer = new byte[bytesToRead];
        }
        if ((read = this.srcAudioInputStream.read(this.buffer, 0, bytesToRead)) == -1) {
            return read;
        }
        if (read % this.frameSize != 0) {
            throw new IOException("Audio stream out of frame constraints.");
        }
        int readFrames = read / this.frameSize;
        for (int i = 0; i < readFrames; ++i) {
            this.bufferProcessor.getFloatValues(this.buffer, i * this.frameSize, normBuf[frameOffset + i]);
        }
        return readFrames;
    }

    public void setFramePosition(long newPos) throws IOException {
        for (long toSkip = newPos * (long)this.frameSize; toSkip > 0L; toSkip -= this.srcAudioInputStream.skip(toSkip)) {
        }
    }

    public long skip(long skip) throws IOException {
        return this.skipFrames(skip);
    }

    public long skipFrames(long arg0) throws IOException {
        long skipped;
        block4: {
            long toSkip = arg0 * (long)this.frameSize;
            skipped = 0L;
            try {
                skipped = this.srcAudioInputStream.skip(toSkip);
            }
            catch (IOException e) {
                if (!this.useReadOnSkipException || toSkip <= Integer.MAX_VALUE) break block4;
                int bufSize = DEFAULT_BUF_SIZE_IN_FRAMES * this.frameSize;
                if (this.buffer.length < bufSize) {
                    this.buffer = new byte[bufSize];
                }
                skipped = this.srcAudioInputStream.read(this.buffer);
            }
        }
        if (skipped % (long)this.frameSize != 0L) {
            throw new IOException("Audio stream out of frame constraints.");
        }
        return skipped / (long)this.frameSize;
    }

    public String toString() {
        return new String("Float value audio stream (scale -1 to +1) based on:" + this.srcAudioInputStream.toString());
    }

    public boolean isUseReadOnSkipException() {
        return this.useReadOnSkipException;
    }

    public void setUseReadOnSkipException(boolean useReadOnSkipException) {
        this.useReadOnSkipException = useReadOnSkipException;
    }

    public Integer getChannels() {
        return this.channels;
    }
}

