/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class LevelInfo {
    private float level;
    private float peakLevel;
    private float intervalPeakLevel;
    private float peakLevelHold;
    private PropertyChangeSupport propertyChangeSupport;

    public float getIntervalPeakLevel() {
        return this.intervalPeakLevel;
    }

    public void resetIntervalPeakLevel() {
        this.intervalPeakLevel = this.peakLevel;
    }

    public LevelInfo() {
        this(0.0f, 0.0f);
    }

    public LevelInfo(float level, float peakLevel) {
        this.level = level;
        this.peakLevel = peakLevel;
        this.intervalPeakLevel = peakLevel;
        this.peakLevelHold = 0.0f;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public float getLevel() {
        return this.level;
    }

    public void setLevel(float level) {
        float oldValue = this.level;
        this.level = level;
        this.propertyChangeSupport.firePropertyChange("level", Float.valueOf(oldValue), Float.valueOf(level));
    }

    public float getPeakLevel() {
        return this.peakLevel;
    }

    public void setPeakLevel(float peakLevel) {
        float oldValue = this.peakLevel;
        this.peakLevel = peakLevel;
        if (peakLevel > this.intervalPeakLevel) {
            this.intervalPeakLevel = peakLevel;
        }
        this.propertyChangeSupport.firePropertyChange("peakLevel", Float.valueOf(oldValue), Float.valueOf(peakLevel));
    }

    public float getPeakLevelHold() {
        return this.peakLevelHold;
    }

    public void setPeakLevelHold(float peakLevelHold) {
        float oldValue = this.peakLevelHold;
        this.peakLevelHold = peakLevelHold;
        this.propertyChangeSupport.firePropertyChange("peakLevelHold", Float.valueOf(oldValue), Float.valueOf(peakLevelHold));
    }

    public void resetPeakLevelHold() {
        this.setPeakLevelHold(0.0f);
    }

    public LevelInfo mergePeakLevelHold(LevelInfo levelInfoToMerge) {
        float mPeakLevelHold;
        if (levelInfoToMerge == null) {
            levelInfoToMerge = new LevelInfo();
        }
        if ((mPeakLevelHold = levelInfoToMerge.getPeakLevelHold()) < this.peakLevelHold) {
            levelInfoToMerge.setPeakLevelHold(this.peakLevelHold);
        }
        return levelInfoToMerge;
    }

    public LevelInfo merge(LevelInfo levelInfoToMerge) {
        float mPeakLevel;
        float mLevel;
        if (levelInfoToMerge == null) {
            levelInfoToMerge = new LevelInfo();
        }
        if ((mLevel = levelInfoToMerge.getLevel()) < this.level) {
            levelInfoToMerge.setLevel(this.level);
        }
        if ((mPeakLevel = levelInfoToMerge.getPeakLevel()) < this.peakLevel) {
            levelInfoToMerge.setPeakLevel(this.peakLevel);
        }
        this.mergePeakLevelHold(levelInfoToMerge);
        return levelInfoToMerge;
    }

    public String toString() {
        return new String(super.toString() + ", Level: " + this.level + ", Peak: " + this.peakLevel + ", Peakhold: " + this.peakLevelHold);
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.addPropertyChangeListener(arg0);
    }

    public void addPropertyChangeListener(String arg0, PropertyChangeListener arg1) {
        this.propertyChangeSupport.addPropertyChangeListener(arg0, arg1);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

