/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.FloatAudioInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;

public class VolumeControlStream
extends FloatAudioInputStream {
    private double volume = 1.0;
    private boolean limit = false;

    public VolumeControlStream(AudioInputStream srcAudioInputStream) throws AudioFormatNotSupportedException {
        super(srcAudioInputStream);
    }

    public VolumeControlStream(AudioInputStream srcAudioInputStream, boolean limit) throws AudioFormatNotSupportedException {
        super(srcAudioInputStream);
        this.limit = limit;
    }

    @Override
    public int read(float[][] normBuf, int frameOffset, int frames) throws IOException {
        int readFrames = super.read(normBuf, frameOffset, frames);
        if (readFrames > 0) {
            for (int f = frameOffset; f < readFrames; ++f) {
                float[] frame = normBuf[f];
                for (int ch = 0; ch < frame.length; ++ch) {
                    if (this.limit) {
                        float val = frame[ch] * (float)this.volume;
                        if ((double)val > 1.0) {
                            val = 1.0f;
                        } else if ((double)val < -1.0) {
                            val = -1.0f;
                        }
                        frame[ch] = val;
                        continue;
                    }
                    frame[ch] = frame[ch] * (float)this.volume;
                }
            }
        }
        return readFrames;
    }

    @Override
    public int read(double[][] normBuf, int frameOffset, int frames) throws IOException {
        int readFrames = super.read(normBuf, frameOffset, frames);
        if (readFrames > 0) {
            for (int f = frameOffset; f < readFrames; ++f) {
                double[] frame = normBuf[f];
                for (int ch = 0; ch < frame.length; ++ch) {
                    if (this.limit) {
                        double val = frame[ch] * this.volume;
                        if (val > 1.0) {
                            val = 1.0;
                        } else if (val < -1.0) {
                            val = -1.0;
                        }
                        frame[ch] = val;
                        continue;
                    }
                    frame[ch] = frame[ch] * this.volume;
                }
            }
        }
        return readFrames;
    }

    public float getVolume() {
        return (float)this.volume;
    }

    public void setVolume(float volume) {
        this.volume = volume;
    }

    public double getGainRatio(double gainRatio) {
        return this.volume;
    }

    public void setGainRatio(double volume) {
        this.volume = volume;
    }

    public boolean isLimit() {
        return this.limit;
    }

    public void setLimit(boolean limit) {
        this.limit = limit;
    }
}

