/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp.ui;

import ipsk.audio.dsp.AudioClipDSPInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.sound.sampled.AudioFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class AudioClipDSPInfoViewer
extends JPanel {
    private static DecimalFormat LEN_SECONDS_FORMAT = new DecimalFormat("0.000 s");
    private static DecimalFormat AMPL_LOG_FORMAT = new DecimalFormat("0.00 db");
    private static DecimalFormat AMPL_LIN_FORMAT = new DecimalFormat("0.0000");
    private static DecimalFormat SNR_LOG_FORMAT = new DecimalFormat("0.00 db");
    private AudioClipDSPInfo audioClipDSPInfo;

    public AudioClipDSPInfoViewer(AudioClipDSPInfo info) {
        super(new GridBagLayout());
        this.audioClipDSPInfo = info;
        if (info != null) {
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 2;
            c.insets = new Insets(2, 5, 2, 5);
            c.anchor = 19;
            c.gridx = 0;
            c.gridy = 0;
            this.add((Component)new JLabel("Length: "), c);
            ++c.gridx;
            this.add((Component)new JLabel(LEN_SECONDS_FORMAT.format(info.getFrameLengthInSeconds()) + " , " + info.getFrameLength() + " frames"), c);
            c.gridx = 0;
            ++c.gridy;
            AudioFormat af = info.getAudioFormat();
            int channels = af.getChannels();
            this.add((Component)new JLabel("Format: "), c);
            ++c.gridx;
            this.add((Component)new JLabel(af.getSampleRate() + " Hz, " + af.getSampleSizeInBits() + " bit, "), c);
            c.gridx = 0;
            ++c.gridy;
            double[] maxAmpl = info.getMaxAmplitudes();
            double[] minAmpl = info.getMinAmplitudes();
            double[] maxLogAmpl = info.getMaxLogarithmLevels();
            double[] minLogAmpl = info.getMinLogarithmLevels();
            Double[] snrs = info.getEstimatedLogarithmSignalToBackgroundNoiseRatio();
            for (int i = 0; i < channels; ++i) {
                this.add((Component)new JLabel("Channel " + Integer.toString(i) + ":"), c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel("Max amplitude:"), c);
                ++c.gridx;
                double maxAmplNorm1 = maxAmpl[i] * 2.0;
                JLabel maxLabel = new JLabel(AMPL_LIN_FORMAT.format(maxAmplNorm1) + " (" + AMPL_LOG_FORMAT.format(maxLogAmpl[i]) + ")");
                if (Math.abs(maxAmplNorm1) >= 0.999) {
                    maxLabel.setForeground(Color.RED);
                }
                this.add((Component)maxLabel, c);
                c.gridx = 0;
                ++c.gridy;
                this.add((Component)new JLabel("Min amplitude:"), c);
                ++c.gridx;
                double minAmplNorm1 = minAmpl[i] * 2.0;
                JLabel minLabel = new JLabel(AMPL_LIN_FORMAT.format(minAmplNorm1) + " (" + AMPL_LOG_FORMAT.format(minLogAmpl[i]) + ")");
                if (Math.abs(minAmplNorm1) >= 0.999) {
                    minLabel.setForeground(Color.RED);
                }
                this.add((Component)minLabel, c);
                if (snrs != null && snrs[i] != null) {
                    c.gridx = 0;
                    ++c.gridy;
                    this.add((Component)new JLabel("(Estimated SNR: "), c);
                    ++c.gridx;
                    JLabel snrLabel = new JLabel(SNR_LOG_FORMAT.format(snrs[i]) + ")");
                    this.add((Component)snrLabel, c);
                }
                c.gridx = 0;
                ++c.gridy;
            }
        }
    }
}

