/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.io.InterleavedChannelRoutingInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class ChannelRoutingAudioInputStream
extends AudioInputStream {
    private InterleavedChannelRoutingInputStream iis;

    public ChannelRoutingAudioInputStream(InputStream stream, AudioFormat format, long length, Integer[] channelRouting) {
        super(stream, format, length);
        int outChannels = format.getChannels();
        int sampleSize = format.getFrameSize() / outChannels;
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
        int inputChannelCount = maxInIdx + 1;
        this.iis = new InterleavedChannelRoutingInputStream(stream, sampleSize, inputChannelCount, channelRouting);
    }

    public ChannelRoutingAudioInputStream(AudioInputStream stream, int srcChannelCount, AudioFormat format, long length, Integer[] channelRouting) throws AudioFormatNotSupportedException {
        super(stream, format, length);
        int outChannels = format.getChannels();
        int sampleSize = format.getFrameSize() / outChannels;
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
        int inputChannelCountByAssignment = maxInIdx + 1;
        AudioFormat af = stream.getFormat();
        if (srcChannelCount < inputChannelCountByAssignment) {
            throw new AudioFormatNotSupportedException(af);
        }
        this.iis = new InterleavedChannelRoutingInputStream((InputStream)stream, sampleSize, srcChannelCount, channelRouting);
    }

    public ChannelRoutingAudioInputStream(AudioInputStream stream, AudioFormat format, long length, Integer[] channelRouting) throws AudioFormatNotSupportedException {
        super(stream, format, length);
        int outChannels = format.getChannels();
        int sampleSize = format.getFrameSize() / outChannels;
        int maxInIdx = -1;
        Integer[] integerArray = channelRouting;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int r = integerArray[i];
            if (r <= maxInIdx) continue;
            maxInIdx = r;
        }
        int inputChannelCountByAssignment = maxInIdx + 1;
        AudioFormat af = stream.getFormat();
        int srcChannelCount = af.getChannels();
        if (srcChannelCount < inputChannelCountByAssignment) {
            throw new AudioFormatNotSupportedException(af);
        }
        this.iis = new InterleavedChannelRoutingInputStream((InputStream)stream, sampleSize, srcChannelCount, channelRouting);
    }
}

