/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioPluginException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Control;

public abstract class BasicPCMPlugin
implements AudioPlugin {
    protected AudioFormat[] supportedAudioFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, -1, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, -1, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, -1, -1, -1.0f, false)};
    protected AudioFormat inputFormat;
    protected AudioFormat outputFormat;

    @Override
    public abstract AudioInputStream getAudioInputStream(AudioInputStream var1) throws AudioPluginException;

    @Override
    public AudioFormat[] getSupportedInputFormats() {
        return this.supportedAudioFormats;
    }

    @Override
    public AudioFormat[] getSupportedOutputFormats(AudioFormat inputFormat) {
        if (this.isInputFormatSupported(inputFormat)) {
            return new AudioFormat[]{inputFormat};
        }
        return new AudioFormat[0];
    }

    @Override
    public Control[] getControls() {
        return new Control[0];
    }

    @Override
    public boolean isInputFormatSupported(AudioFormat audioFormat) {
        for (int i = 0; i < this.supportedAudioFormats.length; ++i) {
            AudioFormat suppFormat = this.supportedAudioFormats[i];
            if (!suppFormat.getEncoding().equals(audioFormat.getEncoding()) || suppFormat.getSampleRate() != -1.0f && suppFormat.getSampleRate() != audioFormat.getSampleRate() || suppFormat.getSampleSizeInBits() != -1 && suppFormat.getSampleSizeInBits() != audioFormat.getSampleSizeInBits() || suppFormat.getChannels() != -1 && (suppFormat.getChannels() != audioFormat.getChannels() || suppFormat.getFrameSize() != -1 && suppFormat.getFrameSize() != audioFormat.getFrameSize() || suppFormat.getFrameRate() != -1.0f && suppFormat.getFrameRate() != audioFormat.getFrameRate() || suppFormat.getSampleSizeInBits() > 8 && suppFormat.isBigEndian() != audioFormat.isBigEndian())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOutputFormatSupported(AudioFormat inputFormat, AudioFormat outputFormat) {
        return this.isInputFormatSupported(inputFormat) && outputFormat.matches(inputFormat);
    }

    @Override
    public void setInputFormat(AudioFormat inputFormat) throws AudioFormatNotSupportedException {
        if (!this.isInputFormatSupported(inputFormat)) {
            throw new AudioFormatNotSupportedException(inputFormat);
        }
        this.inputFormat = inputFormat;
    }

    @Override
    public AudioFormat getInputFormat() {
        return this.inputFormat;
    }

    @Override
    public void setOutputFormat(AudioFormat outputFormat) throws AudioFormatNotSupportedException {
        if (!this.isOutputFormatSupported(this.inputFormat, outputFormat)) {
            throw new AudioFormatNotSupportedException(outputFormat);
        }
        this.outputFormat = outputFormat;
    }

    @Override
    public AudioFormat getOutputFormat() {
        return this.outputFormat;
    }
}

