/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPluginException;
import ipsk.audio.arr.Selection;
import ipsk.audio.plugins.BasicPCMPlugin;
import ipsk.io.CuttingInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class CutPlugin
extends BasicPCMPlugin {
    private Selection selection;
    AudioInputStream ais;
    AudioInputStream editAudioInputStream;
    OutputStream os;
    AudioFileFormat aff;
    AudioFormat af;
    long frameLength;
    int frameSize;
    boolean signed = true;

    public CutPlugin(long from, long length) {
        this.selection = new Selection();
        this.selection.setStart(from);
        this.selection.setEnd(from + length);
    }

    public CutPlugin(Selection s) {
        this.selection = s;
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        if (this.selection == null) {
            return ais;
        }
        this.frameLength = ais.getFrameLength();
        this.af = ais.getFormat();
        this.frameSize = this.af.getFrameSize();
        if (this.af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            this.signed = true;
        } else if (this.af.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.signed = false;
        } else {
            throw new AudioPluginException(new AudioFormatNotSupportedException(this.af));
        }
        long from = this.selection.getLeft();
        long length = this.selection.getLength();
        if (from == -1L) {
            from = this.frameLength;
        }
        if (length == -1L) {
            length = this.frameLength;
        }
        if (from + length > this.frameLength) {
            length = this.frameLength - from;
        }
        long resLength = this.frameLength - length;
        CuttingInputStream eis = new CuttingInputStream((InputStream)ais, this.frameSize, from, length);
        return new AudioInputStream((InputStream)eis, this.af, resLength);
    }
}

