/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.sampled.spi.test;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class EncoderTest
extends Thread {
    private File audioFile;
    private AudioFormat.Encoding encoding;
    private AudioFileFormat.Type targetType;

    public EncoderTest(File audioFile, AudioFormat.Encoding encoding, AudioFileFormat.Type targetType) {
        this.audioFile = audioFile;
        this.encoding = encoding;
        this.targetType = targetType;
    }

    @Override
    public void run() {
        AudioFileFormat aff;
        try {
            aff = AudioSystem.getAudioFileFormat(this.audioFile);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        System.out.println(aff);
        AudioInputStream ais = null;
        try {
            String srcFilename = this.audioFile.getAbsolutePath();
            String extension = aff.getType().getExtension();
            String extUpperCase = extension.toUpperCase(Locale.ENGLISH);
            String extLowerCase = extension.toLowerCase(Locale.ENGLISH);
            String extPattern = "";
            for (int i = 0; i < extension.length(); ++i) {
                extPattern = extPattern.concat("[" + extLowerCase.substring(i, i) + extUpperCase.substring(i, i) + "]");
            }
            String regex = extPattern + "$";
            String trgFilename = srcFilename.replaceFirst(regex, this.targetType.getExtension());
            if (srcFilename.equals(trgFilename)) {
                throw new IOException("Could not create target file name by replacing extension");
            }
            File testFile = new File(trgFilename);
            if (testFile.exists()) {
                throw new IOException("Target file " + testFile + " already exists");
            }
            ais = AudioSystem.getAudioInputStream(this.audioFile);
            AudioInputStream decAis = AudioSystem.getAudioInputStream(this.encoding, ais);
            AudioSystem.write(decAis, this.targetType, testFile);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

