/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.synth;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.io.FramedInputStream;
import ipsk.math.random.GaussianDistributionRandomGenerator;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class WhiteNoiseGenerator
extends FramedInputStream {
    public static final int DEFAULT_BUF_SIZE_FRAMES = 1024;
    private long position = 0L;
    private AudioFrameProcessor ap;
    private int channels;
    private int frameSize;
    private GaussianDistributionRandomGenerator gg;
    private double[] valBuf;
    long length;

    public WhiteNoiseGenerator(AudioFormat audioFormat, long length) throws AudioFormatNotSupportedException {
        super(audioFormat.getFrameSize());
        this.length = length;
        this.channels = audioFormat.getChannels();
        this.ap = new AudioFrameProcessor(audioFormat);
        this.frameSize = this.ap.getFrameSize();
        this.valBuf = new double[1 * this.channels];
        this.gg = new GaussianDistributionRandomGenerator();
    }

    public int read(byte[] buf, int offset, int len) throws IOException {
        int samples;
        int frames = len / this.frameSize;
        if (this.length != -1L) {
            long rest = this.length - this.position;
            if (rest == 0L) {
                return -1;
            }
            if ((long)frames > rest) {
                frames = (int)rest;
            }
        }
        if (this.valBuf.length < (samples = frames * this.channels)) {
            this.valBuf = new double[samples];
        }
        this.gg.fillWithGaussionDistributedValues(this.valBuf, 0, samples);
        this.ap.encode(this.valBuf, 0, buf, 0, samples);
        this.position += (long)frames;
        return frames * this.frameSize;
    }
}

