/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tools;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.FileAudioSource;
import ipsk.audio.dsp.FloatRandomAccessStream;
import ipsk.audio.dsp.XCorrelator;
import ipsk.audio.tools.FrameUnitParser;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;

public class AudiofileCorrelator {
    AudioSource srcAs;
    AudioSource corrAs;
    AudioFileFormat aff;
    AudioFormat af;
    long frameLength;
    int frameSize;
    boolean signed = true;

    public AudiofileCorrelator(AudioSource srcAs, AudioSource corrAs) throws AudioFormatNotSupportedException, AudioSourceException {
        this.srcAs = srcAs;
        this.corrAs = corrAs;
        this.frameLength = srcAs.getFrameLength();
        this.af = srcAs.getFormat();
        this.frameSize = this.af.getFrameSize();
        if (this.af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            this.signed = true;
        } else if (this.af.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.signed = false;
        } else {
            throw new AudioFormatNotSupportedException(this.af);
        }
    }

    public XCorrelator.CorrResult corr(long from, long length) throws IOException, AudioSourceException, AudioFormatNotSupportedException {
        if (from == -1L) {
            from = this.frameLength;
        }
        if (length == -1L) {
            length = this.frameLength;
        }
        if (from + length > this.frameLength) {
            length = this.frameLength - from;
        }
        XCorrelator xcorr = new XCorrelator(new FloatRandomAccessStream(this.srcAs), new FloatRandomAccessStream(this.corrAs));
        return xcorr.correlate(from, from + length);
    }

    public XCorrelator.CorrResult corrFromEnd(long toCorrelateFromEnd) throws AudioSourceException, IOException, AudioFormatNotSupportedException {
        long frameLength = this.srcAs.getFrameLength();
        long from = frameLength - toCorrelateFromEnd;
        if (from < 0L) {
            throw new IllegalArgumentException("Cannot correlate. Source Stream is too short to correlate.");
        }
        return this.corr(from, toCorrelateFromEnd);
    }

    private static void printUsage() {
        System.out.println("Usage: java ipsk.audio.tools.AudiofileCorrelator srcFile corrFile command [ cmdparm1 ] ...[cmdparmn]\n       commands:\n       corr correlate from frameLength\nFrame position and length values have the following syntax:\nfloating point values with appended 's' or 'ms' are interpreted as time (seconds respectively millisecond) values,\ninteger values are interpreted as audio frame values\nThe constant end can be used for the end of the sourceuadio file.\nExamples:\ncorr 0 end : cross correlates the whole source file\ncorr end-1s end : cross correlates last second of the file\ncorr 100000 end : cross correlates from frame 100000 to the end.\n");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            AudiofileCorrelator.printUsage();
            System.exit(-1);
        } else {
            File srcFile = new File(args[0]);
            File corrFile = new File(args[1]);
            FileAudioSource srcAs = new FileAudioSource(srcFile);
            FrameUnitParser fup = null;
            AudiofileCorrelator ae = null;
            XCorrelator.CorrResult result = null;
            try {
                fup = new FrameUnitParser(srcAs);
                ae = new AudiofileCorrelator(srcAs, new FileAudioSource(corrFile));
            }
            catch (Exception e1) {
                System.err.println(e1.getLocalizedMessage());
                e1.printStackTrace();
            }
            String cmd = args[2];
            String[] cmdOpts = new String[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                cmdOpts[i - 3] = args[i];
            }
            if (cmd.equals("corr")) {
                long pos = 0L;
                long len = 0L;
                if (cmdOpts.length != 2) {
                    AudiofileCorrelator.printUsage();
                    System.exit(-1);
                }
                try {
                    pos = fup.parseFrameUnitString(cmdOpts[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[0] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    len = fup.parseFrameUnitString(cmdOpts[1]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[1] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    result = ae.corr(pos, len);
                }
                catch (Exception e) {
                    System.err.println("Cannot correlate file: " + e.getLocalizedMessage());
                    System.exit(-1);
                }
                float fromEnd = 0.0f;
                try {
                    fromEnd = (float)((srcAs.getFrameLength() - result.getPosition()) * 1000L) / srcAs.getFormat().getFrameRate();
                }
                catch (AudioSourceException e) {
                    e.printStackTrace();
                }
                System.out.println(result + " " + fromEnd + "ms from end");
            } else {
                System.err.println("Unknown command: " + cmd);
                AudiofileCorrelator.printUsage();
                System.exit(-1);
            }
        }
    }
}

