/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tools;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.arr.Selection;
import ipsk.audio.tools.AudioFileEditorException;
import ipsk.io.EditInputStream;
import ipsk.io.InterleaveEditInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudiofileEditor {
    private AudioInputStream ais;
    private AudioInputStream editAudioInputStream;
    private AudioFormat af;
    private long frameLength;
    private int frameSize;
    private boolean signed = true;

    public AudiofileEditor(AudioInputStream ais) throws AudioFormatNotSupportedException {
        this.ais = ais;
        this.frameLength = ais.getFrameLength();
        this.af = ais.getFormat();
        this.frameSize = this.af.getFrameSize();
        if (this.af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            this.signed = true;
        } else if (this.af.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            this.signed = false;
        } else {
            throw new AudioFormatNotSupportedException(this.af);
        }
    }

    public AudioInputStream cut(Selection s) throws IOException {
        return this.cut(s.getLeft(), s.getLength());
    }

    public AudioInputStream cut(long from, long length) throws IOException {
        if (from == -1L) {
            from = this.frameLength;
        }
        if (length == -1L) {
            length = this.frameLength;
        }
        if (from + length > this.frameLength) {
            length = this.frameLength - from;
        }
        EditInputStream eis = new EditInputStream((InputStream)this.ais, this.frameSize, from, length);
        this.editAudioInputStream = new AudioInputStream((InputStream)eis, this.af, length);
        return this.editAudioInputStream;
    }

    public AudioInputStream shorten(long toCut) throws IOException {
        return this.cut(0L, this.frameLength - toCut);
    }

    public AudioInputStream cutFromEnd(long toCutFromEnd) throws IOException {
        return this.cut(this.frameLength - toCutFromEnd, this.frameLength);
    }

    private AudioInputStream pick(int ch) {
        int sampleBytes = this.af.getSampleSizeInBits() / 8;
        if (this.af.getSampleSizeInBits() % 8 > 0) {
            ++sampleBytes;
        }
        int off = ch * sampleBytes;
        InterleaveEditInputStream eis = new InterleaveEditInputStream((InputStream)this.ais, this.af.getFrameSize(), off, sampleBytes);
        AudioFormat pickAf = new AudioFormat(this.af.getSampleRate(), this.af.getSampleSizeInBits(), 1, this.signed, this.af.isBigEndian());
        this.editAudioInputStream = new AudioInputStream((InputStream)eis, pickAf, this.ais.getFrameLength());
        return this.editAudioInputStream;
    }

    public AudioInputStream append(AudioInputStream ais2) throws AudioFileEditorException {
        if (!this.ais.getFormat().matches(ais2.getFormat())) {
            throw new AudioFileEditorException("Cannot append streams with different audio formats !");
        }
        SequenceInputStream resStream = new SequenceInputStream(this.ais, ais2);
        return new AudioInputStream(resStream, this.af, -1L);
    }

    private static void printUsage() {
        System.out.println("Usage: java ipsk.audio.tools.AudiofileEditor audioInputFile audioOutputFile command [ cmdparm1 ] ...[cmdparmn]\n       commands:\n       cut from frameLength\n       cut_from_end frames\n       shorten frames\n       pick channelindex\n       append filename\nNote: All position and frameLength values must be given in audio frames.\nNote: channelindex counts from channel 0.");
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            AudiofileEditor.printUsage();
            System.exit(-1);
        } else {
            File inFile = null;
            File outFile = null;
            AudioInputStream ais = null;
            try {
                inFile = new File(args[0]);
                ais = AudioSystem.getAudioInputStream(inFile);
            }
            catch (UnsupportedAudioFileException e) {
                System.err.println(e.getLocalizedMessage());
            }
            catch (IOException e) {
                System.err.println("Cannot open " + args[0] + ": " + e.getLocalizedMessage());
            }
            outFile = new File(args[1]);
            AudiofileEditor ae = null;
            try {
                ae = new AudiofileEditor(ais);
            }
            catch (AudioFormatNotSupportedException e1) {
                System.err.println(e1.getLocalizedMessage());
                e1.printStackTrace();
            }
            String cmd = args[2];
            String[] cmdOpts = new String[args.length - 3];
            for (int i = 3; i < args.length; ++i) {
                cmdOpts[i - 3] = args[i];
            }
            if (cmd.equals("cut")) {
                long pos = 0L;
                long len = 0L;
                if (cmdOpts.length != 2) {
                    AudiofileEditor.printUsage();
                    System.exit(-1);
                }
                try {
                    pos = Long.parseLong(cmdOpts[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[0] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    len = Long.parseLong(cmdOpts[1]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[1] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    AudioSystem.write(ae.cut(pos, len), AudioSystem.getAudioFileFormat(inFile).getType(), outFile);
                }
                catch (IOException e) {
                    System.err.println("Cannot cut file: " + e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (UnsupportedAudioFileException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            } else if (cmd.equals("cut_from_end")) {
                long len = 0L;
                if (cmdOpts.length != 1) {
                    AudiofileEditor.printUsage();
                    System.exit(-1);
                }
                try {
                    len = Long.parseLong(cmdOpts[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[0] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    AudioSystem.write(ae.cutFromEnd(len), AudioSystem.getAudioFileFormat(inFile).getType(), outFile);
                }
                catch (IOException e) {
                    System.err.println("Cannot cut file: " + e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (UnsupportedAudioFileException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            } else if (cmd.equals("shorten")) {
                long toCut = 0L;
                if (cmdOpts.length != 1) {
                    AudiofileEditor.printUsage();
                    System.exit(-1);
                }
                try {
                    toCut = Long.parseLong(cmdOpts[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[0] + " is not a number!");
                    System.exit(-1);
                }
                try {
                    AudioSystem.write(ae.shorten(toCut), AudioSystem.getAudioFileFormat(inFile).getType(), outFile);
                }
                catch (IOException e) {
                    System.err.println("Cannot shorten file: " + e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (UnsupportedAudioFileException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            } else if (cmd.equals("pick")) {
                int ch = 0;
                if (cmdOpts.length != 1) {
                    AudiofileEditor.printUsage();
                    System.exit(-1);
                }
                try {
                    ch = Integer.parseInt(cmdOpts[0]);
                }
                catch (NumberFormatException e) {
                    System.err.println(cmdOpts[0] + " is not a channel number!");
                    System.exit(-1);
                }
                try {
                    AudioSystem.write(ae.pick(ch), AudioSystem.getAudioFileFormat(inFile).getType(), outFile);
                }
                catch (IOException e) {
                    System.err.println("Cannot shorten file: " + e.getLocalizedMessage());
                    System.exit(-1);
                }
                catch (UnsupportedAudioFileException e) {
                    System.err.println(e.getLocalizedMessage());
                    System.exit(-1);
                }
            } else if (cmd.equals("append")) {
                File appendFile = null;
                if (cmdOpts.length != 1) {
                    AudiofileEditor.printUsage();
                    System.exit(-1);
                }
                appendFile = new File(cmdOpts[0]);
                try {
                    AudioSystem.write(ae.append(AudioSystem.getAudioInputStream(appendFile)), AudioSystem.getAudioFileFormat(inFile).getType(), outFile);
                }
                catch (Exception e) {
                    System.err.println(e.getLocalizedMessage());
                }
            } else {
                System.err.println("Unknown command: " + cmd);
                AudiofileEditor.printUsage();
                System.exit(-1);
            }
        }
    }
}

