/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.view;

import ipsk.audio.dsp.LevelInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.sound.sampled.AudioFormat;
import javax.swing.JPanel;

public class LevelDisplay
extends JPanel
implements PropertyChangeListener {
    public static final boolean DEBUG = false;
    private static final float NEEDLE_DEFLECTION_RETURN_SPEED = 0.011764706f;
    private static final int PEAK_HOLD_BAR_WIDTH = 5;
    private LevelInfo levelInfo = null;
    private float level = Float.NEGATIVE_INFINITY;
    private float peakHold;
    private int horizontalBorder = 2;
    private float minDisplayLevel;
    private float peak;
    private static final float ln = (float)(20.0 / Math.log(10.0));
    private float yellowThresHoldIndB = -6.0f;
    private float redThresHoldIndB = -3.0f;
    private float currentPaintLevel;
    private float currentPaintPeakLevel;
    private boolean useIntervalPeakLevel = false;
    private long lastPainted;
    private boolean levelInfoPropertyListener = false;
    private Color levelColorPeak;
    private Color levelColorPeakDarker;
    private Color levelColorWarn;
    private Color levelColorWarnDarker;
    private Color levelColor;
    private Color levelColorDarker;
    private float transparency = 1.0f;
    private boolean active = true;

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        this.repaint();
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float transparency) {
        this.transparency = transparency;
        this.updateColors();
    }

    public LevelDisplay(float minDisplayLevel) {
        this.setMinDisplayDezibelLevel(minDisplayLevel);
        this.level = minDisplayLevel;
        this.currentPaintLevel = minDisplayLevel;
        this.currentPaintPeakLevel = minDisplayLevel;
        this.resetPeak();
        this.resetPeakHold();
        this.lastPainted = System.currentTimeMillis();
        this.updateColors();
    }

    private Color transparentColor(Color opaqueColor, float transParency) {
        int transpInt = (int)(255.0f * this.transparency);
        return new Color(opaqueColor.getRed(), opaqueColor.getGreen(), opaqueColor.getBlue(), transpInt);
    }

    private void updateColors() {
        this.levelColorPeak = Color.RED;
        this.levelColorPeakDarker = Color.RED.darker();
        this.levelColorWarn = Color.YELLOW;
        this.levelColorWarnDarker = Color.YELLOW.darker();
        this.levelColor = Color.GREEN;
        this.levelColorDarker = Color.GREEN.darker();
        if (this.transparency != 1.0f) {
            this.levelColorPeak = this.transparentColor(this.levelColorPeak, this.transparency);
            this.levelColorPeakDarker = this.transparentColor(this.levelColorPeakDarker, this.transparency);
            this.levelColorWarn = this.transparentColor(this.levelColorWarn, this.transparency);
            this.levelColorWarnDarker = this.transparentColor(this.levelColorWarnDarker, this.transparency);
            this.levelColor = this.transparentColor(this.levelColor, this.transparency);
            this.levelColorDarker = this.transparentColor(this.levelColorDarker, this.transparency);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(10, 100);
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(1, 10);
    }

    public void setMinDisplayDezibelLevel(float minDisplayLevel) {
        this.minDisplayLevel = minDisplayLevel;
        this.repaint();
    }

    private void levelInfoUpdate() {
        if (this.levelInfo == null) {
            this.level = 0.0f;
            this.peak = 0.0f;
        } else {
            this.level = (float)((double)ln * Math.log(this.levelInfo.getLevel()));
            float linPeak = this.levelInfoPropertyListener || !this.useIntervalPeakLevel ? this.levelInfo.getPeakLevel() : this.levelInfo.getIntervalPeakLevel();
            this.peak = (float)((double)ln * Math.log(linPeak));
            double peakLevelHold = this.levelInfo.getPeakLevelHold();
            this.peakHold = (float)((double)ln * Math.log(peakLevelHold));
        }
        this.repaint();
    }

    public void setLevelInfo(LevelInfo li) {
        this.setLevelInfo(li, true);
    }

    public void setLevelInfo(LevelInfo li, boolean listenToPropertyChanges) {
        if (li == null) {
            if (this.levelInfo != null) {
                this.levelInfo.removePropertyChangeListener(this);
            }
        } else if (li != this.levelInfo) {
            if (this.levelInfo != null) {
                this.levelInfo.removePropertyChangeListener(this);
            }
            this.levelInfo = li;
            if (listenToPropertyChanges) {
                this.levelInfo.addPropertyChangeListener(this);
            }
        }
        this.levelInfoPropertyListener = listenToPropertyChanges;
        this.levelInfoUpdate();
    }

    public LevelInfo getLevelInfo() {
        return new LevelInfo(this.level, this.peak);
    }

    public void setLevel(float val) {
        this.level = (float)((double)ln * Math.log(val));
        this.setLevelInDezibel(this.level);
    }

    public void setLevelInDezibel(float val) {
        this.level = val;
        if (this.level > this.peak) {
            this.peak = this.level;
        }
        this.repaint();
    }

    public void abandonDecay() {
        this.currentPaintLevel = this.minDisplayLevel;
        this.currentPaintPeakLevel = this.minDisplayLevel;
        this.repaint();
    }

    public void audioFormatChanged(AudioFormat af) {
    }

    public void resetPeak() {
        this.peak = this.minDisplayLevel;
        this.repaint();
    }

    public void resetPeakHold() {
        this.peakHold = this.minDisplayLevel;
        this.repaint();
    }

    public void setPeak(float newPeak) {
        this.peak = newPeak;
    }

    public float getPeak() {
        return this.peak;
    }

    @Override
    public void paintComponent(Graphics g) {
        float peakHoldPos;
        Rectangle2D.Float r2;
        float h;
        float levelHeightTmp;
        float levelHeight;
        float peakLevelDiff;
        float paintLevel;
        super.paintComponent(g);
        if (!this.active) {
            return;
        }
        Insets insets = this.getInsets();
        int currentWidth = this.getWidth() - insets.left - insets.right;
        int currentHeight = this.getHeight() - insets.top - insets.bottom;
        Graphics2D g2 = (Graphics2D)g;
        float levelDiff = this.level - this.currentPaintLevel;
        long now = System.currentTimeMillis();
        float timeIntervall = now - this.lastPainted;
        float step = 0.011764706f * timeIntervall;
        if (levelDiff >= 0.0f) {
            paintLevel = this.level;
            if (paintLevel > this.level) {
                paintLevel = this.level;
            }
        } else {
            paintLevel = this.currentPaintLevel - step;
            if (paintLevel < this.level) {
                paintLevel = this.level;
            }
        }
        if ((peakLevelDiff = this.peak - this.currentPaintPeakLevel) >= 0.0f) {
            this.currentPaintPeakLevel = this.peak;
        } else {
            this.currentPaintPeakLevel -= step;
            if (this.currentPaintPeakLevel < this.peak) {
                this.currentPaintPeakLevel = this.peak;
            }
        }
        if (paintLevel < this.minDisplayLevel) {
            paintLevel = this.minDisplayLevel;
        }
        this.currentPaintLevel = paintLevel;
        this.lastPainted = now;
        float thYellow = this.yellowThresHoldIndB / this.minDisplayLevel * (float)currentHeight;
        float thRed = this.redThresHoldIndB / this.minDisplayLevel * (float)currentHeight;
        float levelBlank = paintLevel / this.minDisplayLevel * (float)currentHeight;
        float peakPos = this.currentPaintPeakLevel / this.minDisplayLevel * (float)currentHeight;
        if (peakPos <= (float)currentHeight) {
            float levelPeakPosTmp = peakPos;
            levelHeightTmp = levelHeight = (float)currentHeight - peakPos;
            if (peakPos < thRed) {
                g2.setPaint(this.levelColorPeakDarker);
                h = thRed - levelPeakPosTmp;
                r2 = new Rectangle2D.Float(this.horizontalBorder, peakPos, currentWidth - 2 * this.horizontalBorder, h);
                g2.fill(r2);
                levelPeakPosTmp = thRed;
                levelHeightTmp -= h;
            }
            if (peakPos < thYellow) {
                g2.setPaint(this.levelColorWarnDarker);
                h = thYellow - levelPeakPosTmp;
                r2 = new Rectangle2D.Float(this.horizontalBorder, levelPeakPosTmp, currentWidth - 2 * this.horizontalBorder, h);
                g2.fill(r2);
                levelPeakPosTmp = thYellow;
                levelHeightTmp -= h;
            }
            r2 = new Rectangle2D.Float(this.horizontalBorder, levelPeakPosTmp, currentWidth - 2 * this.horizontalBorder, levelHeightTmp);
            g2.setPaint(this.levelColorDarker);
            g2.fill(r2);
        }
        if (levelBlank <= (float)currentHeight) {
            float levelBlankTmp = levelBlank;
            levelHeightTmp = levelHeight = (float)currentHeight - levelBlank;
            if (levelBlank < thRed) {
                g2.setPaint(this.levelColorPeak);
                h = thRed - levelBlankTmp;
                r2 = new Rectangle2D.Float(this.horizontalBorder, levelBlank, currentWidth - 2 * this.horizontalBorder, h);
                g2.fill(r2);
                levelBlankTmp = thRed;
                levelHeightTmp -= h;
            }
            if (levelBlank < thYellow) {
                g2.setPaint(this.levelColorWarn);
                h = thYellow - levelBlankTmp;
                r2 = new Rectangle2D.Float(this.horizontalBorder, levelBlankTmp, currentWidth - 2 * this.horizontalBorder, h);
                g2.fill(r2);
                levelBlankTmp = thYellow;
                levelHeightTmp -= h;
            }
            r2 = new Rectangle2D.Float(this.horizontalBorder, levelBlankTmp, currentWidth - 2 * this.horizontalBorder, levelHeightTmp);
            g2.setPaint(this.levelColor);
            g2.fill(r2);
        }
        if ((peakHoldPos = this.peakHold / this.minDisplayLevel * (float)currentHeight) <= (float)currentHeight) {
            if (peakHoldPos < thRed) {
                g2.setPaint(this.levelColorPeak);
            } else if (peakHoldPos < thYellow) {
                g2.setPaint(this.levelColorWarn);
            } else {
                g2.setPaint(this.levelColor);
            }
            float x = this.horizontalBorder;
            float y = peakHoldPos;
            float w = currentWidth - 2 * this.horizontalBorder;
            float h2 = 5.0f;
            r2 = new Rectangle2D.Float(this.horizontalBorder, peakHoldPos, currentWidth - 2 * this.horizontalBorder, 5.0f);
            g2.fill(r2);
        }
    }

    public float getMinDisplayLevel() {
        return this.minDisplayLevel;
    }

    public float getRedThresHoldIndB() {
        return this.redThresHoldIndB;
    }

    public float getYellowThresHoldIndB() {
        return this.yellowThresHoldIndB;
    }

    public void setMinDisplayLevel(float f) {
        this.setMinDisplayDezibelLevel(this.minDisplayLevel);
    }

    public void setRedThresHoldIndB(float f) {
        this.redThresHoldIndB = f;
    }

    public void setYellowThresHoldIndB(float f) {
        this.yellowThresHoldIndB = f;
    }

    public float getPeakHold() {
        return this.peakHold;
    }

    public void setPeakHold(float peakHold) {
        this.peakHold = peakHold;
    }

    public boolean isUseIntervalPeakLevel() {
        return this.useIntervalPeakLevel;
    }

    public void setUseIntervalPeakLevel(boolean useIntervalPeakLevel) {
        this.useIntervalPeakLevel = useIntervalPeakLevel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent arg0) {
        if (arg0.getSource() == this.levelInfo) {
            this.levelInfoUpdate();
        }
    }
}

