/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui;

import ipsk.audio.actions.StartPlaybackAction;
import ipsk.audio.arr.clip.events.AudioClipChangedEvent;
import ipsk.audio.arr.clip.events.AudioSourceChangedEvent;
import ipsk.audio.arr.clip.events.SelectionChangedEvent;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.events.StartPlaybackActionEvent;
import ipsk.swing.JWideButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;

public class FragmentActionBarUI
extends BasicAudioClipUI
implements PropertyChangeListener,
ActionListener {
    private JWideButton buttLeft;
    private Rectangle buttLeftBounds;
    private JWideButton selButt;
    private Rectangle selButtBounds;
    private JWideButton rightButton;
    private Rectangle rightButtonBounds;
    private StartPlaybackAction startPlaybackAction;
    int preferredHeight;
    private JWideButton buttAll;
    private Rectangle buttAllBounds;

    public FragmentActionBarUI() {
        this.setLayout(null);
        this.buttAll = new JWideButton("Play all");
        this.buttAll.addActionListener((ActionListener)this);
        this.buttLeft = new JWideButton("Play (left)");
        this.buttLeft.addActionListener((ActionListener)this);
        this.selButt = new JWideButton("Play selection");
        this.selButt.addActionListener((ActionListener)this);
        this.rightButton = new JWideButton("Play (right)");
        this.rightButton.addActionListener((ActionListener)this);
    }

    @Override
    public String getName() {
        return "Play selection bar";
    }

    @Override
    public boolean isPreferredFixedHeight() {
        return true;
    }

    private void update() {
        this.removeAll();
        if (this.viewSelection == null) {
            this.buttAllBounds = new Rectangle(0, 0, this.getWidth(), this.preferredHeight);
            this.buttAll.setBounds(this.buttAllBounds);
            this.add((Component)this.buttAll);
            this.preferredHeight = this.buttAll.getPreferredSize().height;
        } else {
            int vsBegin = this.viewSelection.getXLeft();
            int vsEnd = this.viewSelection.getXRight();
            int vsLen = Math.abs(vsEnd - vsBegin);
            this.buttLeftBounds = new Rectangle(0, 0, vsBegin, this.preferredHeight);
            this.buttLeft.setBounds(this.buttLeftBounds);
            this.add((Component)this.buttLeft);
            this.selButtBounds = new Rectangle(vsBegin, 0, vsLen, this.preferredHeight);
            this.selButt.setBounds(this.selButtBounds);
            this.add((Component)this.selButt);
            this.rightButtonBounds = new Rectangle(vsEnd, 0, this.getWidth() - vsEnd, this.preferredHeight);
            this.rightButton.setBounds(this.rightButtonBounds);
            this.add((Component)this.rightButton);
            this.preferredHeight = this.selButt.getPreferredSize().height;
        }
        this.setPreferredSize(new Dimension(this.getWidth(), this.preferredHeight));
        this.setMinimumSize(this.getPreferredSize());
        this.revalidate();
        this.repaint();
    }

    @Override
    public void audioClipChanged(AudioClipChangedEvent event) {
        super.audioClipChanged(event);
        if (event instanceof AudioSourceChangedEvent || event instanceof SelectionChangedEvent) {
            this.update();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        StartPlaybackActionEvent pae = null;
        if (src == this.selButt) {
            pae = new StartPlaybackActionEvent((Object)this, this.selection.getLeft(), this.selection.getRight());
        } else if (src == this.buttLeft) {
            pae = new StartPlaybackActionEvent((Object)this, 0L, this.selection.getLeft());
        } else if (src == this.rightButton) {
            pae = new StartPlaybackActionEvent((Object)this, this.selection.getRight(), -1L);
        } else if (src == this.buttAll) {
            pae = new StartPlaybackActionEvent((Object)this, 0L, -1L);
        }
        if (pae != null) {
            this.startPlaybackAction.actionPerformed(pae);
        }
    }

    public void setStartPlaybackAction(StartPlaybackAction startPlaybackAction) {
        this.startPlaybackAction = startPlaybackAction;
        startPlaybackAction.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean enabled = ((Action)evt.getSource()).isEnabled();
        this.buttAll.setEnabled(enabled);
        this.buttLeft.setEnabled(enabled);
        this.selButt.setEnabled(enabled);
        this.rightButton.setEnabled(enabled);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.update();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.buttAll != null) {
            this.buttAll.updateUI();
            this.buttLeft.updateUI();
            this.selButt.updateUI();
            this.rightButton.updateUI();
        }
    }
}

