/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.dsp.BufferInfo;
import java.util.ArrayList;
import java.util.List;

public class BufferInfoArray<T extends BufferInfo> {
    private static final boolean DEBUG = false;
    private List<T> bufferInfos;
    private int length;
    private int position;
    private int lastMatch;

    public BufferInfoArray() {
        this(512);
    }

    public BufferInfoArray(int capacity) {
        this.length = capacity;
        this.bufferInfos = new ArrayList<T>(capacity);
        for (int i = 0; i < this.length; ++i) {
            this.bufferInfos.add(null);
        }
        this.position = 0;
        this.lastMatch = 0;
    }

    public int getLength() {
        return this.length;
    }

    public void add(T bi) {
        this.bufferInfos.set(this.position++, bi);
        if (this.position == this.length) {
            this.position = 0;
        }
    }

    public void clear() {
        for (int i = 0; i < this.length; ++i) {
            this.bufferInfos.set(i, null);
        }
        this.position = 0;
    }

    private boolean matches(T bi, long framePosition) {
        long biFramePos = ((BufferInfo)bi).getFramePosition();
        long biEnd = biFramePos + (long)((BufferInfo)bi).getFrameLength();
        return framePosition >= biFramePos && framePosition < biEnd;
    }

    private boolean tangents(T bi, long startFramePosition, long endFramePosition) {
        long biFramePos = ((BufferInfo)bi).getFramePosition();
        long biEnd = biFramePos + (long)((BufferInfo)bi).getFrameLength();
        return biFramePos >= startFramePosition ? biFramePos <= endFramePosition : biEnd >= startFramePosition;
    }

    private int bufferInfoIndexAtFramePosition(long framePosition) {
        BufferInfo bi;
        int i;
        for (i = this.lastMatch; i < this.length; ++i) {
            bi = (BufferInfo)this.bufferInfos.get(i);
            if (bi == null || !this.matches(bi, framePosition)) continue;
            this.lastMatch = i;
            return i;
        }
        for (i = 0; i < this.lastMatch; ++i) {
            bi = (BufferInfo)this.bufferInfos.get(i);
            if (bi == null || !this.matches(bi, framePosition)) continue;
            this.lastMatch = i;
            return i;
        }
        return -1;
    }

    public BufferInfo getBufferInfoAtFramePosition(long framePosition) {
        int idx = this.bufferInfoIndexAtFramePosition(framePosition);
        if (idx < 0) {
            return null;
        }
        return (BufferInfo)this.bufferInfos.get(idx);
    }

    public List<T> listBufferInfosTangentInterval(long fromFramePosition, long toFramePosition) {
        long endFp;
        long startFp;
        ArrayList<BufferInfo> biList = new ArrayList<BufferInfo>();
        if (fromFramePosition <= toFramePosition) {
            startFp = fromFramePosition;
            endFp = toFramePosition;
        } else {
            startFp = toFramePosition;
            endFp = fromFramePosition;
        }
        int startIdx = this.bufferInfoIndexAtFramePosition(startFp);
        if (startIdx >= 0) {
            BufferInfo bi;
            int i;
            for (i = startIdx; i < this.length; ++i) {
                bi = (BufferInfo)this.bufferInfos.get(i);
                if (bi == null) continue;
                if (this.tangents(bi, startFp, endFp)) {
                    this.lastMatch = i;
                    biList.add(bi);
                    continue;
                }
                return biList;
            }
            for (i = 0; i < startIdx; ++i) {
                bi = (BufferInfo)this.bufferInfos.get(i);
                if (bi == null) continue;
                if (this.tangents(bi, startFp, endFp)) {
                    this.lastMatch = i;
                    biList.add(bi);
                    continue;
                }
                return biList;
            }
        }
        return biList;
    }

    public synchronized boolean isAvailable(long framePosition, int length) {
        long endPosition = framePosition + (long)length;
        for (int i = 0; i < this.length; ++i) {
            long biFramePos;
            BufferInfo bi = (BufferInfo)this.bufferInfos.get(i);
            if (bi == null || framePosition < (biFramePos = bi.getFramePosition()) || endPosition > biFramePos + (long)bi.getFrameLength()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Buffer info array: idx pos: " + this.position + ", length: " + this.length + ", last match: " + this.lastMatch);
        sb.append("\nwith buffer infos:\n");
        for (BufferInfo bi : this.bufferInfos) {
            if (bi == null) continue;
            sb.append(bi);
            sb.append("\n");
        }
        return sb.toString();
    }
}

