/*
 * Decompiled with CFR 0.152.
 */
package ips.incubator.audio.arr.clip.ui;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.AudioClip;
import ipsk.audio.arr.clip.ui.BasicAudioClipUI;
import ipsk.audio.dsp.FloatRandomAccessStream;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

public class EnergyAudioClipUI
extends BasicAudioClipUI {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;

    @Override
    public String getName() {
        return "Energy density";
    }

    public EnergyAudioClipUI(AudioClip annotatedAudioClip) throws AudioFormatNotSupportedException, AudioSourceException {
        super(annotatedAudioClip);
    }

    public EnergyAudioClipUI() {
    }

    public void setAudioClip(AudioClip annotatedAudioClip) {
        super.setAudioSample(annotatedAudioClip);
    }

    @Override
    public Dimension getPreferredSize() {
        int prefHeight = 100;
        return new Dimension(0, prefHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int w = this.getSize().width;
        int h = this.getSize().height;
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, w, h);
        g.setColor(Color.BLUE);
        AudioSource audioSource = this.getAudioSample().getAudioSource();
        if (audioSource != null) {
            double[] energyDensities = new double[w];
            double maxenergyDensity = 0.0;
            try {
                FloatRandomAccessStream fras = new FloatRandomAccessStream(audioSource);
                int chs = fras.getChannels();
                long pixelFrames = this.mapPixelToFrame(1);
                double[][] buf = new double[(int)pixelFrames][chs];
                for (int p = 0; p < w - 1; ++p) {
                    long startframe = this.mapPixelToFrame(p);
                    long endFrame = this.mapPixelToFrame(p + 1);
                    fras.setFramePosition(startframe);
                    int r = fras.readFrames(buf, 0, (int)pixelFrames);
                    double energy = 0.0;
                    for (int f = 0; f < r; ++f) {
                        double amp = buf[f][0];
                        energy += amp * amp;
                    }
                    double ed = energy / (double)r;
                    if (ed > maxenergyDensity) {
                        maxenergyDensity = ed;
                    }
                    energyDensities[p] = ed;
                }
                for (int x = 0; x < w - 1; ++x) {
                    int y1 = (int)((double)h * energyDensities[x] / maxenergyDensity);
                    int y2 = (int)((double)h * energyDensities[x + 1] / maxenergyDensity);
                    g.drawLine(x, h - y1, x + 1, h - y2);
                }
            }
            catch (AudioSourceException e) {
                e.printStackTrace();
            }
            catch (AudioFormatNotSupportedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public boolean isPreferredFixedHeight() {
        return false;
    }
}

