/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui.audiosignal;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRendererEvent;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRendererListener;
import ipsk.audio.dsp.FloatRandomAccessStream;
import java.awt.Color;
import java.util.concurrent.Callable;

public class AudioSignalModelRenderer
implements Runnable,
Callable<RenderResult> {
    private static final boolean DEBUG = false;
    private static final long MAX_BUF_SIZE_IN_SAMPLES = 32768L;
    private static final int DEFAULT_NOTIFY_ON_PIXELS = 100;
    private static final int WAIT_FOR_THREAD_ON_CLOSE = 1000;
    private final Color DEFAULT_SIGNAL_COLOR = Color.GREEN;
    public static final int DEFAULT_BASELOG_LEVEL = -40;
    private AudioSource audioSource;
    private volatile Request request = new Request();
    private double[][] buf = null;
    private volatile RenderResult rs = new RenderResult();
    private Thread thread = null;
    private boolean open = true;
    private AudioSignalModelRendererListener listener;
    private volatile Object threadNotify = new Object();
    private int notifyOnPixels = 100;
    private Throwable renderException;
    private AudioSignalUI.AmplitudeScaleType amplitudeScaleType = AudioSignalUI.AmplitudeScaleType.LINEAR;
    private double baseLogLevel;
    private double borderLength;
    private Color backgroundColor = null;
    private Color signalColor = this.DEFAULT_SIGNAL_COLOR;
    private boolean paintPolygons = true;

    public AudioSignalModelRenderer(AudioSource audioSource, AudioSignalModelRendererListener listener) throws AudioFormatNotSupportedException, AudioSourceException {
        this.audioSource = audioSource;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderResult render(int fromPixel, int toPixel, double framesPerPixel, boolean useThread, boolean forceRendering) throws AudioSourceException {
        Object object = this.threadNotify;
        synchronized (object) {
            Request newRequest = new Request(fromPixel, toPixel, framesPerPixel);
            if ((useThread || this.request.rendered) && newRequest.equals(this.request) && !forceRendering) {
                this.rs.offset = 0;
                this.rs.length = this.rs.values.length;
                return this.rs;
            }
            long startFramePos = (long)(framesPerPixel * (double)newRequest.fromPixel);
            int startValuePixelPos = (int)((double)startFramePos / framesPerPixel);
            long endFramePos = (long)(framesPerPixel * (double)newRequest.toPixel) + 1L;
            int endValuePixelPos = (int)((double)endFramePos / framesPerPixel);
            if ((useThread || this.request.rendered) && newRequest.isIn(this.request) && !forceRendering) {
                this.rs.offset = startValuePixelPos - this.rs.pixelOffset;
                this.rs.length = endValuePixelPos - startValuePixelPos;
                return this.rs;
            }
            this.rs.isValid = false;
            this.rs = new RenderResult();
            this.rs.pixelOffset = startValuePixelPos;
            this.rs.offset = 0;
            this.rs.length = endValuePixelPos - startValuePixelPos;
            this.rs.values = new Value[this.rs.length];
            this.rs.rendered = false;
            this.request.copy(newRequest);
            this.renderException = null;
            if (useThread) {
                if (this.thread == null) {
                    this.thread = new Thread((Runnable)this, "AudioSignalRenderer");
                    this.thread.start();
                }
                this.threadNotify.notifyAll();
            } else {
                this._render(true);
            }
            return this.rs;
        }
    }

    public Value[] startRender(int fromPixel, int toPixel, double framesPerPixel) throws AudioSourceException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        do {
            try {
                this._render(false);
            }
            catch (AudioSourceException e) {
                e.printStackTrace();
                this._close();
                this.listener.update(new AudioSignalModelRendererEvent((Object)this, e));
            }
            Object object = this.threadNotify;
            synchronized (object) {
                while (this.open && (this.rs == null || !this.rs.isValid || this.rs.rendered)) {
                    try {
                        this.threadNotify.wait(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        } while (this.open);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _render(boolean dry) throws AudioSourceException {
        FloatRandomAccessStream fras;
        double framesPerPixel;
        int endPixel;
        RenderResult rs = null;
        Object object = this.threadNotify;
        synchronized (object) {
            int startPixel = this.request.fromPixel;
            endPixel = this.request.toPixel;
            framesPerPixel = this.request.framesPerPixel;
            rs = this.rs;
        }
        int lastValuePixelPos = -1;
        int renderedPixels = 0;
        try {
            fras = new FloatRandomAccessStream(this.audioSource);
        }
        catch (AudioFormatNotSupportedException e) {
            e.printStackTrace();
            throw new AudioSourceException(e);
        }
        for (int pixelPos = startPixel; pixelPos <= endPixel && rs.isValid; ++pixelPos) {
            int r;
            int bufSize;
            try {
                if (!dry) {
                    Thread.sleep(0L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            long framePos = (long)(framesPerPixel * (double)pixelPos);
            int valuePixelPos = (int)((double)framePos / framesPerPixel);
            if (valuePixelPos == lastValuePixelPos) continue;
            long nextFramePos = (long)(framesPerPixel * (double)(pixelPos + 1));
            long lastFrame = (long)(framesPerPixel * (double)endPixel + 1.0);
            long frameLength = fras.getFrameLength();
            int channels = fras.getChannels();
            rs.channels = channels;
            if (frameLength != (long)ThreadSafeAudioSystem.NOT_SPECIFIED && lastFrame > frameLength - 1L) {
                lastFrame = frameLength - 1L;
            }
            if (framePos > lastFrame) break;
            if (nextFramePos > lastFrame) {
                nextFramePos = lastFrame;
            }
            Value v = new Value(channels);
            long bufSizeLong = (int)(nextFramePos - framePos);
            long samples = bufSizeLong * (long)channels;
            if (samples > 32768L) {
                bufSizeLong = 32768L / (long)channels;
            }
            if ((bufSize = (int)bufSizeLong) == 0) {
                bufSize = 1;
            }
            if (this.buf == null || this.buf.length < bufSize) {
                this.buf = new double[bufSize][channels];
            }
            fras.setFramePosition(framePos);
            int read = 0;
            int toRead = bufSize;
            while (read < bufSize && (r = fras.readFrames(this.buf, read, toRead)) != -1) {
                read += r;
                toRead -= r;
            }
            if (read > 0) {
                v = new Value(channels);
                for (int i = 0; i < channels; ++i) {
                    v.min[i] = this.buf[0][i];
                    v.max[i] = this.buf[0][i];
                }
                for (int j = 1; j < read; ++j) {
                    for (int i = 0; i < channels; ++i) {
                        if (v.min[i] > this.buf[j][i]) {
                            v.min[i] = this.buf[j][i];
                        }
                        if (!(v.max[i] < this.buf[j][i])) continue;
                        v.max[i] = this.buf[j][i];
                    }
                }
                int arrPos = valuePixelPos - rs.pixelOffset;
                if (arrPos < rs.values.length) {
                    rs.values[arrPos] = v;
                }
            }
            lastValuePixelPos = valuePixelPos;
            ++renderedPixels;
            Object object2 = this.threadNotify;
            synchronized (object2) {
                if (!dry && rs.isValid && renderedPixels % this.notifyOnPixels == 0) {
                    this.listener.update(new AudioSignalModelRendererEvent((Object)this, rs));
                }
                continue;
            }
        }
        fras.close();
        Object object3 = this.threadNotify;
        synchronized (object3) {
            if (rs.isValid) {
                rs.rendered = true;
                this.request.rendered = true;
                this.listener.update(new AudioSignalModelRendererEvent((Object)this, rs));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _close() {
        Object object = this.threadNotify;
        synchronized (object) {
            this.open = false;
            this.rs.isValid = false;
            this.threadNotify.notifyAll();
        }
    }

    public void close() {
        this._close();
        try {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getNotifyOnPixels() {
        return this.notifyOnPixels;
    }

    public void setNotifyOnPixels(int notifyOnPixels) {
        this.notifyOnPixels = notifyOnPixels;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setSignalColor(Color signalColor) {
        this.signalColor = signalColor;
    }

    public Color getSignalColor() {
        return this.signalColor;
    }

    @Override
    public RenderResult call() throws Exception {
        this._render(false);
        return this.rs;
    }

    public class Request {
        int fromPixel;
        int toPixel;
        double framesPerPixel;
        boolean rendered;

        public Request() {
        }

        public Request(int fromPixel, int toPixel, double framesPerPixel) {
            this.fromPixel = fromPixel;
            this.toPixel = toPixel;
            this.framesPerPixel = framesPerPixel;
            this.rendered = false;
        }

        public void copy(Request r) {
            this.fromPixel = r.fromPixel;
            this.toPixel = r.toPixel;
            this.framesPerPixel = r.framesPerPixel;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request r = (Request)o;
            return this.fromPixel == r.fromPixel && this.toPixel == r.toPixel && this.framesPerPixel == r.framesPerPixel;
        }

        public boolean isIn(Request r) {
            if (r == null) {
                return false;
            }
            if (this.framesPerPixel != r.framesPerPixel) {
                return false;
            }
            if (this.fromPixel < r.fromPixel) {
                return false;
            }
            return this.toPixel <= r.toPixel;
        }

        public String toString() {
            return new String("Render request from: " + this.fromPixel + ",to: " + this.toPixel + ",frames per pixel: " + this.framesPerPixel);
        }
    }

    public static class RenderResult {
        public Integer channels = null;
        public volatile Value[] values;
        public volatile int pixelOffset;
        public volatile int offset;
        public volatile int length;
        public volatile boolean rendered;
        volatile boolean isValid = true;
    }

    public static class Value {
        double[] min;
        double[] max;

        public Value(int pixelPos, double[] min, double[] max) {
            this.min = min;
            this.max = max;
        }

        public Value(int channels) {
            this.min = new double[channels];
            this.max = new double[channels];
        }
    }
}

