/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr.clip.ui.audiosignal;

import ipsk.audio.arr.clip.ui.AudioSignalUI;
import ipsk.audio.arr.clip.ui.audiosignal.AudioSignalModelRenderer;
import ipsk.audio.dsp.DSPUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;

public class AudioSignalPainter<T> {
    private static final int DEFAULT_NOTIFY_ON_PIXELS = 100;
    private static final int WAIT_FOR_THREAD_ON_CLOSE = 1000;
    private final Color DEFAULT_SIGNAL_COLOR = Color.GREEN;
    public static final int DEFAULT_BASELOG_LEVEL = -40;
    private AudioSignalModelRenderer.RenderResult renderResult;
    private AudioSignalUI.AmplitudeScaleType amplitudeScaleType = AudioSignalUI.AmplitudeScaleType.LINEAR;
    private double baseLogLevel;
    private double borderLength;
    private Color backgroundColor = null;
    private Color signalColor = this.DEFAULT_SIGNAL_COLOR;
    private boolean paintPolygons = true;

    public AudioSignalPainter(AudioSignalModelRenderer.RenderResult rr) {
        this.renderResult = rr;
    }

    public AudioSignalPainter() {
    }

    public void paint(Graphics2D g, T obj, int width, int height) {
        Integer channels;
        Rectangle cb = g.getClipBounds();
        int fromPixel = cb.x;
        int toPixel = cb.x + cb.width;
        if (this.backgroundColor != null) {
            g.setColor(this.backgroundColor);
            g.fillRect(fromPixel, 0, toPixel - fromPixel, height);
        }
        if ((channels = this.renderResult.channels) == null) {
            return;
        }
        int imgHeight = height / channels;
        int[] minY = new int[channels.intValue()];
        int[] maxY = new int[channels.intValue()];
        int[][] polyX = new int[channels.intValue()][4];
        int[][] polyY = new int[channels.intValue()][4];
        g.setColor(this.signalColor);
        boolean firstValue = true;
        int to = this.renderResult.offset + this.renderResult.length;
        for (int valPos = this.renderResult.offset; valPos < to; ++valPos) {
            AudioSignalModelRenderer.Value v = this.renderResult.values[valPos];
            if (v == null) continue;
            int pixelPos = valPos + this.renderResult.pixelOffset;
            for (int i = 0; i < channels; ++i) {
                double maxLevel;
                double minLevel;
                if (this.amplitudeScaleType.equals((Object)AudioSignalUI.AmplitudeScaleType.LINEAR)) {
                    minLevel = v.min[i];
                    maxLevel = v.max[i];
                } else {
                    double normDblevelMax;
                    double logLevelMin = DSPUtils.toPowerLevelInDB(Math.abs(v.min[i]));
                    double logLevelMax = DSPUtils.toPowerLevelInDB(Math.abs(v.max[i]));
                    double normDblevelMin = 1.0 - logLevelMin / this.baseLogLevel;
                    if (normDblevelMin < 0.0) {
                        normDblevelMin = 0.0;
                    }
                    if ((normDblevelMax = 1.0 - logLevelMax / this.baseLogLevel) < 0.0) {
                        normDblevelMax = 0.0;
                    }
                    if (v.min[i] < 0.0) {
                        normDblevelMin = -normDblevelMin;
                    }
                    if (v.max[i] < 0.0) {
                        normDblevelMax = -normDblevelMax;
                    }
                    minLevel = normDblevelMin;
                    maxLevel = normDblevelMax;
                }
                minY[i] = (int)((0.5 - minLevel / 2.0) * (double)imgHeight + (double)(i * imgHeight) + this.borderLength);
                maxY[i] = (int)((0.5 - maxLevel / 2.0) * (double)imgHeight + (double)(i * imgHeight) + this.borderLength);
                if (this.paintPolygons) {
                    if (firstValue) {
                        polyX[i][0] = pixelPos;
                        polyY[i][0] = minY[i];
                        polyX[i][1] = pixelPos;
                        polyY[i][1] = maxY[i];
                        polyX[i][2] = pixelPos;
                        polyY[i][2] = minY[i];
                        polyX[i][3] = pixelPos;
                        polyY[i][3] = maxY[i];
                    } else {
                        polyX[i][0] = polyX[i][2];
                        polyY[i][0] = polyY[i][2];
                        polyX[i][1] = polyX[i][3];
                        polyY[i][1] = polyY[i][3];
                        polyX[i][2] = pixelPos;
                        polyY[i][2] = minY[i];
                        polyX[i][3] = pixelPos;
                        polyY[i][3] = maxY[i];
                    }
                    Polygon p = new Polygon(polyX[i], polyY[i], 4);
                    g.drawPolygon(p);
                    continue;
                }
                g.drawLine(pixelPos, minY[i], pixelPos, maxY[i]);
            }
            firstValue = false;
        }
    }

    public AudioSignalModelRenderer.RenderResult getRenderResult() {
        return this.renderResult;
    }

    public void setRenderResult(AudioSignalModelRenderer.RenderResult renderResult) {
        this.renderResult = renderResult;
    }
}

