/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioSampleProcessor;
import javax.sound.sampled.AudioFormat;

public class AudioFrameProcessor
extends AudioSampleProcessor {
    static final boolean DEBUG = false;
    private float[] floatValues;

    public AudioFrameProcessor(AudioFormat af) throws AudioFormatNotSupportedException {
        super(af);
        this.floatValues = new float[af.getChannels()];
    }

    public float[] getFloatValues(byte[] frameData) {
        return this.getFloatValues(frameData, 0);
    }

    public float[] getFloatValues(byte[] frameData, int offset) {
        for (int i = 0; i < this.channels; ++i) {
            this.floatValues[i] = this.getFloatValue(frameData, i * this.sampleSize + offset);
        }
        return this.floatValues;
    }

    public void getNormalizedInterleavedValues(byte[] frameData, int frames, double[][] normBuffer, int normBufferFrameOffset) {
        for (int f = 0; f < frames; ++f) {
            for (int i = 0; i < this.channels; ++i) {
                normBuffer[normBufferFrameOffset + f][i] = this.getNormalizedValue(frameData, f * this.frameSize + i * this.sampleSize);
            }
        }
    }

    public void getNormalizedInterleavedValues(byte[] frameData, int frameDataOffset, int frames, double[][] normBuffer, int normBufferFrameOffset) {
        for (int f = 0; f < frames; ++f) {
            for (int i = 0; i < this.channels; ++i) {
                normBuffer[normBufferFrameOffset + f][i] = this.getNormalizedValue(frameData, frameDataOffset + f * this.frameSize + i * this.sampleSize);
            }
        }
    }

    public void getNormalizedValues(byte[] frameData, int offset, double[] normBuffer) {
        for (int i = 0; i < this.channels; ++i) {
            normBuffer[i] = this.getNormalizedValue(frameData, i * this.sampleSize + offset);
        }
    }

    public void getDoubleValues(byte[] frameData, int offset, double[] buffer) {
        for (int i = 0; i < this.channels; ++i) {
            buffer[i] = this.getDoubleValue(frameData, i * this.sampleSize + offset);
        }
    }

    public void getFloatValues(byte[] frameData, int offset, float[] buffer) {
        for (int i = 0; i < this.channels; ++i) {
            buffer[i] = this.getFloatValue(frameData, i * this.sampleSize + offset);
        }
    }

    public void encodeToFloatValues(float[] values, byte[] buf, int offset) {
        for (int i = 0; i < this.channels; ++i) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
        }
    }

    public void encodeValues(float[] values, byte[] buf, int offset) {
        for (int i = 0; i < this.channels; ++i) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
        }
    }

    public void encodeValues(double[] values, byte[] buf, int offset) {
        for (int i = 0; i < this.channels; ++i) {
            this.encodeValue(values[i], buf, offset + i * this.sampleSize);
        }
    }

    public void encode(double[][] values, int srcOffset, byte[] buf, int offset, int frames) {
        int trgPos = offset;
        for (int f = 0; f < frames; ++f) {
            this.encodeValues(values[srcOffset + f], buf, trgPos);
            trgPos += this.frameSize;
        }
    }

    public void encode(double[] values, int srcOffset, byte[] buf, int offset, int samples) {
        int srcPos = srcOffset;
        int trgPos = offset;
        for (int s = 0; s < samples; ++s) {
            this.encodeValue(values[srcPos], buf, trgPos);
            ++srcPos;
            trgPos += this.sampleSize;
        }
    }
}

