/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.AudioFrameProcessor;
import ipsk.audio.dsp.FloatAudioInputStream;
import ipsk.io.FramedInputStream;
import ipsk.io.InterleavedFloatStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;

public class FloatToPCMInputStream
extends FramedInputStream {
    private AudioFormat pcmFormat;
    private InterleavedFloatStream inStream;
    private double[][] inBuf;
    private int frameSize;
    private AudioFrameProcessor frameProcessor;

    public FloatToPCMInputStream(FloatAudioInputStream audioInStream) throws AudioFormatNotSupportedException {
        this(audioInStream, audioInStream.getFormat());
    }

    public FloatToPCMInputStream(InterleavedFloatStream inStream, AudioFormat pcmFormat) throws AudioFormatNotSupportedException {
        super(pcmFormat.getFrameSize());
        this.inStream = inStream;
        this.pcmFormat = pcmFormat;
        this.frameSize = pcmFormat.getFrameSize();
        this.frameProcessor = new AudioFrameProcessor(pcmFormat);
    }

    public int read(byte[] buf, int offset, int length) throws IOException {
        int read = 0;
        int framesToRead = length / this.frameSize;
        if (length % this.frameSize > 0) {
            throw new IOException("Bytes to read must be multiple of framesize!");
        }
        if (this.inBuf == null || framesToRead > this.inBuf.length) {
            this.inBuf = new double[framesToRead][this.pcmFormat.getChannels()];
        }
        int framesRead = 0;
        framesRead = this.inStream.read(this.inBuf, 0, framesToRead);
        if (framesRead != -1) {
            for (int f = 0; f < framesRead; ++f) {
                this.frameProcessor.encodeValues(this.inBuf[f], buf, offset + read);
                read += this.frameSize;
            }
        } else {
            read = -1;
        }
        return read;
    }
}

