/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.impl.j2audio;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.dsp.PeakDetector;
import ipsk.audio.impl.j2audio.BufferOverrunException;
import ipsk.audio.impl.j2audio.CaptureListener;
import ipsk.audio.impl.j2audio.CaptureStatus;
import ipsk.audio.impl.j2audio.FileWriterListener;
import ipsk.audio.impl.j2audio.FileWriterThread;
import ipsk.audio.impl.j2audio.LineStatus;
import ipsk.io.VectorBufferedInputStream;
import ipsk.io.VectorBufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;

public class Capture
implements Runnable,
LineListener,
FileWriterListener {
    private int maxBufferFill;
    private static final boolean DEBUG = false;
    private static int DEFAULT_BUF_SIZE_IN_FRAMES = 512;
    private FileWriterThread directFileWriterThread;
    private PipedOutputStream outPipe;
    private PipedInputStream inPipe;
    private TargetDataLine tdl = null;
    private int lineBufferSize;
    private int preferredLineBufferSize = -1;
    private LineStatus tdlStatus = new LineStatus("Closed");
    private CaptureStatus cs = new CaptureStatus("Closed");
    private float latencyTime = -1.0f;
    private int bufSize;
    private byte[] buffer;
    private File recFile = null;
    private OutputStream outStream;
    private File tmpFile = null;
    private OutputStream out;
    private Thread tdlThread = null;
    private PeakDetector abp = null;
    private AudioFormat format;
    private int numChannels;
    private float[] levels = new float[0];
    private long blength = 0L;
    private IOException captureException = null;
    private int framePosition = 0;
    private int frameSize;
    private int frameSizeInBytes;
    private AudioFileFormat.Type audioFileFormat = AudioFileFormat.Type.WAVE;
    private boolean useTempFile;
    private AudioInputStream directFileWriterStream = null;
    private VectorBufferedOutputStream outBuffer = null;
    private CaptureListener cl;

    public Capture(CaptureListener cl, TargetDataLine tdl) {
        this.cl = cl;
        this.tdl = tdl;
        this.useTempFile = false;
    }

    public void setUseTempFile(boolean useTempFile) {
        this.useTempFile = useTempFile;
    }

    public void open(AudioFormat af) throws IOException, LineUnavailableException, AudioFormatNotSupportedException {
        this.format = af;
        this.numChannels = af.getChannels();
        this.levels = new float[this.numChannels];
        this.resetLevels();
        this.frameSize = this.format.getFrameSize();
        int tdlBufSizeInFrames = this.latencyTime != -1.0f ? (int)(this.latencyTime * this.format.getSampleRate()) : DEFAULT_BUF_SIZE_IN_FRAMES;
        this.bufSize = this.frameSize * tdlBufSizeInFrames;
        this.latencyTime = (float)tdlBufSizeInFrames / this.format.getSampleRate();
        if (this.useTempFile) {
            this.prepareTmpFile();
            this.outPipe = null;
        }
        this.tdlStatus = new LineStatus("Closed");
        this.tdl.addLineListener(this);
        DataLine.Info tdlInfo = (DataLine.Info)this.tdl.getLineInfo();
        int maxBufSize = tdlInfo.getMaxBufferSize();
        int minBufSize = tdlInfo.getMinBufferSize();
        if (this.preferredLineBufferSize == -1) {
            this.tdl.open(this.format);
        } else {
            int lineBufSizeInFrames = this.preferredLineBufferSize / this.frameSize;
            this.lineBufferSize = lineBufSizeInFrames * this.frameSize;
            this.tdl.open(this.format, this.lineBufferSize);
        }
        this.lineBufferSize = this.tdl.getBufferSize();
        this.tdlStatus.waitFor("Opened");
        this.buffer = new byte[this.bufSize];
        this.abp = new PeakDetector(af);
        this.framePosition = 0;
        this.cs.setStatus("Open");
        this.cl.update(this, this.cs);
    }

    private void resetLevels() {
        for (int i = 0; i < this.numChannels; ++i) {
            this.levels[i] = 0.0f;
        }
    }

    public void prepareToRecord(File recFile) throws IOException {
        this.captureException = null;
        String currCs = this.cs.getStatus();
        if (currCs == "Open" || currCs == "Prepared") {
            this.outStream = null;
            this.recFile = recFile;
            if (!this.useTempFile) {
                this.inPipe = new PipedInputStream();
                this.directFileWriterStream = new AudioInputStream(this.inPipe, this.format, -1L);
                this.outPipe = new PipedOutputStream(this.inPipe);
                this.out = this.outPipe;
                this.directFileWriterThread = new FileWriterThread(this, this.directFileWriterStream, AudioFileFormat.Type.WAVE, recFile);
                this.directFileWriterThread.create();
            }
            this.cs.setStatus("Prepared");
            this.cl.update(this, this.cs);
        }
    }

    public void prepareToRecord(OutputStream os) throws IOException {
        this.captureException = null;
        String currCs = this.cs.getStatus();
        if (currCs == "Open" || currCs == "Prepared") {
            this.recFile = null;
            this.outStream = os;
            if (!this.useTempFile) {
                this.outBuffer = new VectorBufferedOutputStream();
                this.out = this.outBuffer;
            }
            this.cs.setStatus("Prepared");
            this.cl.update(this, this.cs);
        }
    }

    public void startCapturing() {
        this.cs.setStatus("Capturing");
        if (this.tdlStatus.getStatus() != "Started") {
            this.startNewCaptureThread();
            this.tdl.start();
        }
        this.cl.update(this, this.cs);
    }

    public synchronized void startRecording() {
        this.maxBufferFill = 0;
        if (this.cs.getStatus() == "Prepared" || this.cs.getStatus() == "Capturing") {
            this.blength = 0L;
            this.framePosition = 0;
            this.cs.setStatus("Recording");
            if (this.tdlStatus.getStatus() != "Started") {
                this.startNewCaptureThread();
                this.tdl.start();
            }
            if (!this.useTempFile && this.recFile != null) {
                this.directFileWriterThread.start();
            }
            this.cl.update(this, this.cs);
        }
    }

    public void stopRecording() throws IOException {
        if (this.cs.getStatus() == "Recording") {
            block25: {
                this.cs.setStatus("Recorded");
                this.cs.waitForNot("Recorded");
                if (this.tdlThread != null) {
                    try {
                        this.tdlThread.join();
                    }
                    catch (InterruptedException e) {
                        System.err.println(e.getMessage());
                    }
                }
                this.stopTargetDataLine();
                if (this.useTempFile || this.outStream != null) {
                    FileInputStream fis = null;
                    if (this.useTempFile) {
                        try {
                            fis = new FileInputStream(this.tmpFile);
                        }
                        catch (IOException e) {
                            this.prepareTmpFile();
                            this.resetLevels();
                            this.cs.setStatus("Open");
                            System.err.println("Temporary file not found: " + e);
                            throw e;
                        }
                    } else {
                        fis = new VectorBufferedInputStream(this.outBuffer.getVectorBuffer());
                    }
                    AudioInputStream ais = new AudioInputStream(fis, this.format, this.blength / (long)this.frameSizeInBytes);
                    AudioInputStream outs = null;
                    outs = ais;
                    try {
                        if (this.recFile != null) {
                            if (AudioSystem.write(ais, this.audioFileFormat, this.recFile) == -1) {
                                throw new IOException("Problems writing audio file");
                            }
                            break block25;
                        }
                        if (this.outStream != null) {
                            if (AudioSystem.write(ais, this.audioFileFormat, this.outStream) == -1) {
                                throw new IOException("Problems writing audio to OutputStream");
                            }
                            break block25;
                        }
                        throw new IOException("No recording URL or stream to record.");
                    }
                    catch (IOException e) {
                        System.err.println("Error writing file " + e);
                        throw e;
                    }
                    finally {
                        ((InputStream)fis).close();
                        ais.close();
                        outs.close();
                        if (this.outStream != null) {
                            this.outStream.close();
                        }
                        if (this.useTempFile) {
                            this.prepareTmpFile();
                        }
                        this.resetLevels();
                        this.cs.setStatus("Open");
                        try {
                            this.tdlThread.join();
                        }
                        catch (InterruptedException e) {
                            System.err.println("Recording thread interrupted !");
                            e.printStackTrace();
                        }
                    }
                }
            }
            this.cs.waitFor("Open");
            this.cl.update(this, this.cs);
            if (this.captureException != null) {
                throw this.captureException;
            }
        }
    }

    public void stopCapturing() {
        try {
            this.stopTargetDataLine();
        }
        catch (IOException e) {
            System.err.println("IO Error while stopping capture !");
            e.printStackTrace();
        }
    }

    public float[] getLevels() {
        return this.levels;
    }

    public void close() {
        try {
            this.stopRecording();
        }
        catch (IOException e) {
            System.err.println("Exception closing capture device:\n");
            e.printStackTrace();
        }
        finally {
            if (this.tdl.isOpen()) {
                this.tdl.close();
            }
            if (this.tdl != null) {
                this.tdl.removeLineListener(this);
            }
        }
    }

    private void stopTargetDataLine() throws IOException {
        if (this.tdlStatus.getStatus() == "Started") {
            this.tdl.stop();
        }
        this.tdl.flush();
    }

    private void prepareTmpFile() throws IOException {
        if (this.tmpFile != null) {
            this.tmpFile.delete();
        }
        try {
            this.tmpFile = File.createTempFile(this.getClass().getName(), null);
            if (this.tmpFile == null) {
                System.err.println("Cannot get tmpFile");
            }
            this.tmpFile.deleteOnExit();
            this.out = new FileOutputStream(this.tmpFile);
        }
        catch (IOException e) {
            this.captureException = e;
            System.err.println("Cannot get tmpFile " + e);
        }
    }

    private void startNewCaptureThread() {
        this.tdlThread = new Thread(this);
        this.tdlThread.setPriority(6);
        this.tdlThread.setName("Capture");
        this.tdlThread.start();
    }

    @Override
    public synchronized void update(LineEvent le) {
        LineEvent.Type type = le.getType();
        Line src = le.getLine();
        if (src == this.tdl) {
            if (type.equals(LineEvent.Type.OPEN)) {
                this.tdlStatus.setStatus("Opened");
            } else if (type.equals(LineEvent.Type.CLOSE)) {
                this.tdlStatus.setStatus("Closed");
            } else if (type.equals(LineEvent.Type.START)) {
                this.tdlStatus.setStatus("Started");
            } else if (type.equals(LineEvent.Type.STOP)) {
                this.tdlStatus.setStatus("Opened");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.captureException = null;
        this.frameSizeInBytes = this.format.getFrameSize();
        int numBytesRead = 0;
        do {
            int toRead = this.bufSize;
            int available = this.tdl.available();
            if (available == this.tdl.getBufferSize()) {
                System.err.println("Buffer overrun detected !!");
                this.captureException = new BufferOverrunException();
            }
            if (available > this.maxBufferFill) {
                this.maxBufferFill = available;
            }
            if ((numBytesRead = this.tdl.read(this.buffer, 0, toRead)) > 0) {
                if (this.cs.getStatus() == "Recording") {
                    try {
                        this.out.write(this.buffer, 0, numBytesRead);
                        this.framePosition += numBytesRead / this.frameSize;
                        this.blength += (long)numBytesRead;
                    }
                    catch (IOException e) {
                        this.captureException = e;
                        System.err.println("Unable to write to temp file: " + e);
                    }
                }
                this.abp.process(this.buffer, 0, numBytesRead);
                this.levels = this.abp.getPeakLevels();
                continue;
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.cs.getStatus() == "Recording" || this.cs.getStatus() == "Capturing");
        if (this.cs.getStatus() == "Recorded") {
            try {
                this.out.flush();
                this.out.close();
            }
            catch (IOException e) {
                this.captureException = e;
                System.err.println("Cannot flush and close " + e);
            }
            CaptureStatus captureStatus = this.cs;
            synchronized (captureStatus) {
                if (this.cs.getStatus() != "Open") {
                    this.cs.setStatus("Saving");
                }
            }
        }
        this.cs.setStatus("Open");
    }

    public AudioFormat getAudioFormat() {
        return this.format;
    }

    public long getFramePosition() {
        return this.framePosition;
    }

    public void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Object source, int event) {
        if (event == 2) {
            CaptureStatus captureStatus = this.cs;
            synchronized (captureStatus) {
                if (this.cs.getStatus() == "Recorded" || this.cs.getStatus() == "Saving") {
                    this.cs.setStatus("Open");
                    this.cl.update(this, this.cs);
                }
            }
        } else if (event == -1) {
            this.cs.setException(((FileWriterThread)source).getException());
            this.cs.setStatus("Error");
            this.cl.update(this, this.cs);
        }
    }

    public int getPreferredBufferSize() {
        return this.preferredLineBufferSize;
    }

    public void setPreferredBufferSize(int i) {
        this.preferredLineBufferSize = i;
    }

    public float getLatencyTime() {
        return this.latencyTime;
    }

    public void setLatencyTime(float f) {
        this.latencyTime = f;
    }
}

