/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.io.AudioFileWriterException;
import ipsk.audio.io.AudioFileWriterListener;
import ipsk.audio.io.ProgressMonitorAudioInputStream;
import ipsk.audio.io.event.AudioFileWriterEvent;
import ipsk.awt.AWTEventTransferAgent;
import ipsk.awt.ProgressListener;
import ipsk.awt.ProgressWorker;
import ipsk.awt.WorkerException;
import ipsk.awt.event.ProgressEvent;
import ipsk.util.ProgressStatus;
import java.awt.Component;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import java.util.Vector;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;

public class AudioFileWriter
extends ProgressWorker
implements ProgressListener {
    private static final String THREAD_NAME = "Audiofile-Writer";
    private AudioInputStream ais;
    private AudioFileFormat.Type aff;
    private File outFile;
    private EventTransformer evTrans = new EventTransformer();
    private File tmpFile = null;
    private boolean useTempFile = false;
    private ProgressMonitorAudioInputStream pmais = null;
    private boolean cancelled = false;
    private Vector<EventListener> listeners = new Vector();

    public AudioFileWriter(AudioFileWriterListener listener, AudioInputStream ais, AudioFileFormat.Type aff, File outFile) {
        super(THREAD_NAME);
        this.evTrans.addListener(listener);
        this.ais = ais;
        this.aff = aff;
        this.outFile = outFile;
    }

    public AudioFileWriter(AudioFileWriterListener listener, AudioInputStream ais, AudioFileFormat.Type aff, File outFile, Component parentComponent) {
        this(listener, ais, aff, outFile, false);
    }

    public AudioFileWriter(AudioFileWriterListener listener, AudioInputStream ais, AudioFileFormat.Type aff, File outFile, boolean useTempFile) {
        super(THREAD_NAME);
        this.evTrans.addListener(listener);
        this.useTempFile = useTempFile;
        Object aisWriterMsg = null;
        this.aff = aff;
        this.outFile = outFile;
        aisWriterMsg = useTempFile ? "Creating temporary audio file ..." : "Saving to audio file " + outFile.getName() + " ...";
        this.pmais = new ProgressMonitorAudioInputStream(ais);
        this.ais = this.pmais;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void create() throws AudioFileWriterException {
        ByteArrayInputStream zeroBis = new ByteArrayInputStream(new byte[0]);
        AudioInputStream zeroAis = new AudioInputStream(zeroBis, this.ais.getFormat(), 0L);
        try {
            ThreadSafeAudioSystem.write(zeroAis, this.aff, this.outFile);
            return;
        }
        catch (IOException ioe) {
            throw new AudioFileWriterException(ioe);
        }
        finally {
            try {
                zeroBis.close();
            }
            catch (IOException e) {
                throw new AudioFileWriterException(e);
            }
            finally {
                try {
                    zeroAis.close();
                }
                catch (IOException e1) {
                    throw new AudioFileWriterException(e1);
                }
            }
        }
    }

    public void write() throws WorkerException {
        this.open();
        this.start();
        this.close();
        this.reset();
    }

    /*
     * Exception decompiling
     */
    public void doWork() throws WorkerException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void cancel() {
        this.cancelled = true;
        ProgressMonitorAudioInputStream pmaisC = this.pmais;
        if (pmaisC != null) {
            pmaisC.setCancelled(true);
            try {
                pmaisC.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public synchronized void addListener(EventListener eventListener) {
        if (eventListener != null && !this.listeners.contains(eventListener)) {
            this.listeners.addElement(eventListener);
        }
    }

    public synchronized void removeListener(EventListener eventListener) {
        if (eventListener != null) {
            this.listeners.removeElement(eventListener);
        }
    }

    public void update(ProgressEvent progressEvent) {
        if (this.useTempFile) {
            ProgressStatus ps = progressEvent.getProgressStatus();
            this.progressStatus.setProgress((long)(ps.getPercentProgress() / 2));
        }
        this.fireProgressEvent();
    }

    public class EventTransformer
    extends AWTEventTransferAgent<AudioFileWriterListener, AudioFileWriterEvent> {
        public void fireEvent(AudioFileWriterListener afwl, AudioFileWriterEvent ev) {
            afwl.update(ev);
        }
    }
}

