/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.io.push.IAudioOutputStream;
import ipsk.io.IOutputStream;
import ipsk.io.InterceptorInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class InterceptorAudioInputStream
extends AudioInputStream {
    private AudioInputStream srcAudioInputStream;
    private InterceptorInputStream iis;
    private volatile boolean interrupted = false;
    private byte[] buf;

    public InterceptorAudioInputStream(InputStream stream, AudioFormat format, long length) {
        super(stream, format, length);
        this.iis = new InterceptorInputStream(stream);
        this.srcAudioInputStream = new AudioInputStream((InputStream)this.iis, format, length);
        this.buf = new byte[0];
    }

    public InterceptorAudioInputStream(AudioInputStream stream) {
        super(stream, stream.getFormat(), stream.getFrameLength());
        this.iis = new InterceptorInputStream((InputStream)stream);
        this.srcAudioInputStream = new AudioInputStream((InputStream)this.iis, stream.getFormat(), stream.getFrameLength());
        this.buf = new byte[0];
    }

    @Override
    public int available() throws IOException {
        return this.srcAudioInputStream.available();
    }

    @Override
    public void close() throws IOException {
        if (!this.interrupted) {
            this.srcAudioInputStream.close();
        }
    }

    @Override
    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    @Override
    public long getFrameLength() {
        return this.srcAudioInputStream.getFrameLength();
    }

    @Override
    public void mark(int readlimit) {
        this.srcAudioInputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.interrupted) {
            return -1;
        }
        return this.srcAudioInputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interrupted) {
            return -1;
        }
        if (this.buf.length < b.length) {
            this.buf = new byte[b.length];
        }
        int r = this.srcAudioInputStream.read(this.buf, off, len);
        System.arraycopy(this.buf, off, b, off, len);
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.interrupted) {
            return -1;
        }
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        this.srcAudioInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.srcAudioInputStream.skip(n);
    }

    public void addAudioOutputStream(IAudioOutputStream os) throws AudioFormatNotSupportedException {
        this.iis.addOutputStream((IOutputStream)os);
        os.setAudioFormat(this.getFormat());
    }

    public void removeOutputStream(IAudioOutputStream os) {
        this.iis.removeOutputStream((IOutputStream)os);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void setInterrupted(boolean interrupted) {
        this.interrupted = interrupted;
    }
}

