/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io.push;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioSourceException;
import ipsk.audio.io.push.GrowEvent;
import ipsk.audio.io.push.GrowListener;
import ipsk.audio.io.push.GrowingAudioSource;
import ipsk.audio.io.push.IAudioOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class GrowingTempFileAudioSource
implements GrowingAudioSource,
IAudioOutputStream {
    private volatile File tempRawFile;
    private volatile FileOutputStream fileOutputStream;
    private volatile long frameLength = 0L;
    private volatile AudioFormat format;
    private volatile boolean finished = false;
    private Vector<GrowListener> listeners = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AudioInputStream getAudioInputStream() throws AudioSourceException {
        File file = this.tempRawFile;
        synchronized (file) {
            FileInputStream fis;
            try {
                fis = new FileInputStream(this.tempRawFile);
            }
            catch (FileNotFoundException e) {
                throw new AudioSourceException(e);
            }
            AudioInputStream ais = new AudioInputStream(fis, this.format, this.frameLength);
            return ais;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFrameLength() throws AudioSourceException {
        File file = this.tempRawFile;
        synchronized (file) {
            return this.frameLength;
        }
    }

    @Override
    public AudioFormat getFormat() throws AudioSourceException {
        return this.format;
    }

    @Override
    public void addGrowListener(GrowListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeGrowListener(GrowListener l) {
        this.listeners.remove(l);
    }

    private FileOutputStream getTempFileOutputStream() throws IOException {
        if (this.fileOutputStream == null) {
            if (this.tempRawFile == null) {
                this.tempRawFile = File.createTempFile(this.getClass().getName() + "_audio", ".raw");
            }
            this.fileOutputStream = new FileOutputStream(this.tempRawFile);
        }
        return this.fileOutputStream;
    }

    public void write(byte[] buf, int offset, int len) throws IOException {
        FileOutputStream fos = this.getTempFileOutputStream();
        fos.write(buf, offset, len);
        int frameSize = this.format.getFrameSize();
        long frames = len / frameSize;
        this.frameLength += frames;
        GrowEvent ge = new GrowEvent(this.frameLength, this);
        this.fireGrowEvent(ge);
    }

    private void fireGrowEvent(GrowEvent ge) {
        for (GrowListener gl : this.listeners) {
            gl.update(ge);
        }
    }

    public void flush() throws IOException {
        FileOutputStream fos = this.getTempFileOutputStream();
        fos.flush();
    }

    public void close() throws IOException {
        FileOutputStream fos = this.getTempFileOutputStream();
        fos.close();
        this.finished = true;
        GrowEvent ge = new GrowEvent(true, this.frameLength, this);
        this.fireGrowEvent(ge);
    }

    @Override
    public AudioFormat getAudioFormat() {
        try {
            return this.getFormat();
        }
        catch (AudioSourceException e) {
            return null;
        }
    }

    @Override
    public void setAudioFormat(AudioFormat audioFormat) throws AudioFormatNotSupportedException {
        this.format = audioFormat;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void release() {
        if (this.tempRawFile != null) {
            this.tempRawFile.delete();
        }
    }
}

