/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.BooleanControlUI;
import ipsk.audio.mixer.ui.ControlUI;
import ipsk.audio.mixer.ui.EnumControlUI;
import ipsk.audio.mixer.ui.FloatControlUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JLabel;

public class CompoundControlUI
extends ControlUI {
    private Control[] memberControls;
    private ControlUI[] controlUIs;
    private JLabel label;

    public CompoundControlUI(CompoundControl cc) {
        this.setLayout(new BorderLayout());
        this.label = new JLabel(cc.getType().toString());
        this.label.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.memberControls = cc.getMemberControls();
        this.controlUIs = new ControlUI[this.memberControls.length];
        for (int i = 0; i < this.memberControls.length; ++i) {
            Control memberControl = this.memberControls[i];
            if (memberControl instanceof BooleanControl) {
                BooleanControlUI bcUI = new BooleanControlUI((BooleanControl)memberControl);
                this.controlUIs[i] = bcUI;
                continue;
            }
            if (memberControl instanceof FloatControl) {
                FloatControlUI fcUI = new FloatControlUI((FloatControl)memberControl);
                this.controlUIs[i] = fcUI;
                continue;
            }
            if (memberControl instanceof EnumControl) {
                EnumControlUI ecUI = new EnumControlUI((EnumControl)memberControl);
                this.controlUIs[i] = ecUI;
                continue;
            }
            if (!(memberControl instanceof CompoundControl)) continue;
            CompoundControlUI ccUI = new CompoundControlUI((CompoundControl)memberControl);
            this.controlUIs[i] = ccUI;
        }
        Box verticalBox = Box.createHorizontalBox();
        verticalBox.add(Box.createHorizontalGlue());
        Box horizBox = Box.createVerticalBox();
        for (int i = 0; i < this.controlUIs.length; ++i) {
            if (this.controlUIs[i].getPreferredOrientation() == 1) {
                verticalBox.add(this.controlUIs[i]);
                continue;
            }
            horizBox.add(this.controlUIs[i]);
        }
        verticalBox.add(Box.createHorizontalGlue());
        this.add((Component)this.label, "North");
        this.add((Component)verticalBox, "Center");
        this.add((Component)horizBox, "South");
    }

    @Override
    public void setFont(Font f) {
        if (this.label != null) {
            this.label.setFont(f);
        }
        if (this.controlUIs != null) {
            for (int i = 0; i < this.controlUIs.length; ++i) {
                this.controlUIs[i].setFont(f);
            }
        }
        super.setFont(f);
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.controlUIs != null) {
            for (int i = 0; i < this.controlUIs.length; ++i) {
                this.controlUIs[i].setEnabled(enabled);
            }
        }
    }

    @Override
    public void updateValue() {
        for (ControlUI cui : this.controlUIs) {
            cui.updateValue();
        }
    }
}

