/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.LineControlsUI;
import ipsk.swing.TitledPanel;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MixerConfigPanel
extends JPanel {
    private static final boolean DEBUG = false;
    public JRadioButton selectPlayRadioButton;
    public JRadioButton selectCaptureRadioButton;
    private TitledPanel mixerControlPanel = null;
    private LineControlsUI lineControlsUI = null;
    private Mixer.Info mixerInfo;
    private Vector<Port.Info> portInfos;

    public MixerConfigPanel(Mixer mixer, ActionListener al) {
        Object controls;
        this.setLayout(new BoxLayout(this, 1));
        this.mixerInfo = mixer.getMixerInfo();
        JLabel descLabel = new JLabel("Description: " + this.mixerInfo.getDescription());
        JLabel vendorLabel = new JLabel("Vendor: " + this.mixerInfo.getVendor());
        this.add(descLabel);
        this.add(vendorLabel);
        this.selectPlayRadioButton = new JRadioButton("Select for playback.");
        this.selectPlayRadioButton.addActionListener(al);
        this.add(this.selectPlayRadioButton);
        this.selectCaptureRadioButton = new JRadioButton("Select for capture.");
        this.selectCaptureRadioButton.addActionListener(al);
        this.add(this.selectCaptureRadioButton);
        this.portInfos = new Vector();
        Control[] mixerControls = mixer.getControls();
        if (mixerControls.length > 0) {
            this.mixerControlPanel = new TitledPanel("Mixer Controls");
            this.lineControlsUI = new LineControlsUI(mixer);
            this.mixerControlPanel.add((Component)((Object)this.lineControlsUI));
        }
        Line.Info[] sourceLineInfos = mixer.getSourceLineInfo();
        for (int i = 0; i < sourceLineInfos.length; ++i) {
            if (sourceLineInfos[i] instanceof Port.Info) {
                this.portInfos.add((Port.Info)sourceLineInfos[i]);
            } else if (sourceLineInfos[i] instanceof DataLine.Info) {
                DataLine.Info info = (DataLine.Info)sourceLineInfos[i];
            }
            Line l = null;
            try {
                l = mixer.getLine(sourceLineInfos[i]);
            }
            catch (LineUnavailableException e) {
                String errMsg = new String("Error opening audio device\n" + e.getLocalizedMessage());
                JOptionPane.showMessageDialog(this, errMsg, "Error !", 0);
                System.err.println(errMsg);
            }
            controls = l.getControls();
            for (int j = 0; j < ((Control[])controls).length; ++j) {
            }
        }
        Line.Info[] targetLineInfos = mixer.getTargetLineInfo();
        for (int i = 0; i < targetLineInfos.length; ++i) {
            if (targetLineInfos[i] instanceof Port.Info) {
                this.portInfos.add((Port.Info)targetLineInfos[i]);
            } else if (targetLineInfos[i] instanceof DataLine.Info) {
                controls = (DataLine.Info)targetLineInfos[i];
            }
            Line l = null;
            if (l == null) continue;
            Control[] controls2 = l.getControls();
            for (int j = 0; j < controls2.length; ++j) {
            }
        }
        if (this.mixerControlPanel != null) {
            this.add((Component)this.mixerControlPanel);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.selectPlayRadioButton.setEnabled(enabled);
        this.selectCaptureRadioButton.setEnabled(enabled);
        if (this.lineControlsUI != null) {
            this.lineControlsUI.setEnabled(enabled);
        }
    }

    void printFormats(AudioFormat[] fmts) {
        for (int i = 0; i < fmts.length; ++i) {
            System.out.println(i + ". AudioFormat: " + fmts[i]);
        }
    }
}

