/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioFormatNotSupportedException;
import ipsk.audio.AudioPlugin;
import ipsk.audio.AudioPluginException;
import ipsk.io.ChannelRouting;
import ipsk.io.InterleavedChannelRoutingInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.Control;

public class ChannelRoutingPlugin
implements AudioPlugin {
    private ChannelRouting channelRouting;
    private AudioFormat inputFormat;
    private AudioFormat outputFormat;

    public ChannelRouting getChannelRouting() {
        return this.channelRouting;
    }

    public void setChannelRouting(ChannelRouting channelRouting) {
        this.channelRouting = channelRouting;
    }

    public ChannelRoutingPlugin(ChannelRouting channelRouting) {
        this.channelRouting = channelRouting;
    }

    public ChannelRoutingPlugin() {
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        int inChs;
        AudioFormat af = ais.getFormat();
        long frameLength = ais.getFrameLength();
        int channels = af.getChannels();
        if (channels < (inChs = this.channelRouting.getSrcChannels())) {
            throw new AudioPluginException("Cannot route out channel with index " + (inChs - 1) + ", stream has only " + channels + " channels.");
        }
        int frameSize = af.getFrameSize();
        int sampleSize = frameSize / channels;
        Integer[] assnment = this.channelRouting.getAssignment();
        AudioFormat outFormat = new AudioFormat(af.getSampleRate(), af.getSampleSizeInBits(), assnment.length, af.getEncoding() == AudioFormat.Encoding.PCM_SIGNED, af.isBigEndian());
        InterleavedChannelRoutingInputStream editInputStream = new InterleavedChannelRoutingInputStream((InputStream)ais, sampleSize, channels, assnment);
        AudioInputStream editAudioInputStream = new AudioInputStream((InputStream)editInputStream, outFormat, frameLength);
        return editAudioInputStream;
    }

    @Override
    public AudioFormat[] getSupportedInputFormats() {
        int inChannels = this.channelRouting.getSrcChannels();
        AudioFormat[] supportedAudioFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, inChannels, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, inChannels, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, inChannels, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, inChannels, -1, -1.0f, false)};
        return supportedAudioFormats;
    }

    @Override
    public AudioFormat[] getSupportedOutputFormats(AudioFormat inputFormat) {
        int channels = this.channelRouting.getTrgChannels();
        AudioFormat[] supportedAudioFormats = new AudioFormat[]{new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, channels, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, -1, channels, -1, -1.0f, false), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, channels, -1, -1.0f, true), new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, -1.0f, -1, channels, -1, -1.0f, false)};
        return supportedAudioFormats;
    }

    @Override
    public boolean isInputFormatSupported(AudioFormat inputFormat) {
        AudioFormat.Encoding e = inputFormat.getEncoding();
        int inChs = inputFormat.getChannels();
        return (AudioFormat.Encoding.PCM_SIGNED.equals(e) || AudioFormat.Encoding.PCM_UNSIGNED.equals(e)) && inChs >= this.channelRouting.getSrcChannels();
    }

    private boolean matchFormatsIgnoringChannelCount(AudioFormat in, AudioFormat out) {
        return in.getEncoding().equals(out.getEncoding()) && in.getSampleRate() == out.getSampleRate() && in.getSampleSizeInBits() == out.getSampleSizeInBits() && in.getFrameRate() == out.getFrameRate() && in.isBigEndian() == out.isBigEndian();
    }

    @Override
    public boolean isOutputFormatSupported(AudioFormat inputFormat, AudioFormat outputFormat) {
        boolean match;
        boolean bl = match = outputFormat.getChannels() == this.channelRouting.getTrgChannels();
        if (inputFormat != null) {
            match &= this.isInputFormatSupported(inputFormat) && this.matchFormatsIgnoringChannelCount(inputFormat, outputFormat) && inputFormat.getChannels() >= this.channelRouting.getSrcChannels();
        }
        return match;
    }

    @Override
    public void setInputFormat(AudioFormat inputFormat) throws AudioFormatNotSupportedException {
        if (inputFormat != null && !this.isInputFormatSupported(inputFormat)) {
            throw new AudioFormatNotSupportedException(inputFormat);
        }
        this.inputFormat = inputFormat;
    }

    @Override
    public AudioFormat getInputFormat() {
        if (this.inputFormat == null && this.outputFormat != null) {
            int inputChannels = this.channelRouting.getSrcChannels();
            int outChannels = this.outputFormat.getChannels();
            int sampleSize = this.outputFormat.getFrameSize() / outChannels;
            int inputFrameSize = inputChannels * sampleSize;
            this.inputFormat = new AudioFormat(this.outputFormat.getEncoding(), this.outputFormat.getSampleRate(), this.outputFormat.getSampleSizeInBits(), inputChannels, inputFrameSize, this.outputFormat.getFrameRate(), this.outputFormat.isBigEndian());
        }
        return this.inputFormat;
    }

    @Override
    public void setOutputFormat(AudioFormat outputFormat) throws AudioFormatNotSupportedException {
        if (outputFormat == null) {
            this.outputFormat = null;
        } else if (this.isOutputFormatSupported(this.inputFormat, outputFormat)) {
            this.outputFormat = outputFormat;
        } else {
            throw new AudioFormatNotSupportedException(outputFormat);
        }
    }

    @Override
    public AudioFormat getOutputFormat() {
        if (this.outputFormat == null && this.inputFormat != null) {
            int outputChannels = this.channelRouting.getTrgChannels();
            int inputChannels = this.inputFormat.getChannels();
            int sampleSize = this.inputFormat.getFrameSize() / inputChannels;
            int outputFrameSize = outputChannels * sampleSize;
            this.outputFormat = new AudioFormat(this.inputFormat.getEncoding(), this.inputFormat.getSampleRate(), this.inputFormat.getSampleSizeInBits(), outputChannels, outputFrameSize, this.inputFormat.getFrameRate(), this.inputFormat.isBigEndian());
        }
        return this.outputFormat;
    }

    @Override
    public Control[] getControls() {
        return null;
    }
}

