/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.sampled.spi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;

public class AlawRawFileReader
extends AudioFileReader {
    private static RawAlawAudioFileFormatType fileFormatType = new RawAlawAudioFileFormatType();
    private AudioFileFormat fileFormat;
    private AudioFormat format = new AudioFormat(AudioFormat.Encoding.ALAW, 8000.0f, 8, 1, 1, 8000.0f, true);

    public AlawRawFileReader() {
        this.fileFormat = new AudioFileFormat(fileFormatType, this.format, -1);
    }

    @Override
    public AudioFileFormat getAudioFileFormat(File arg0) throws UnsupportedAudioFileException, IOException {
        if (!arg0.getName().endsWith("." + fileFormatType.getExtension())) {
            throw new UnsupportedAudioFileException();
        }
        return this.fileFormat;
    }

    @Override
    public AudioFileFormat getAudioFileFormat(InputStream arg0) throws UnsupportedAudioFileException, IOException {
        throw new UnsupportedAudioFileException();
    }

    @Override
    public AudioFileFormat getAudioFileFormat(URL arg0) throws UnsupportedAudioFileException, IOException {
        if (!arg0.getFile().endsWith("." + fileFormatType.getExtension())) {
            throw new UnsupportedAudioFileException();
        }
        return this.fileFormat;
    }

    @Override
    public AudioInputStream getAudioInputStream(File arg0) throws UnsupportedAudioFileException, IOException {
        if (!arg0.getName().endsWith("." + fileFormatType.getExtension())) {
            throw new UnsupportedAudioFileException();
        }
        return new AudioInputStream(new FileInputStream(arg0), this.format, arg0.length());
    }

    @Override
    public AudioInputStream getAudioInputStream(InputStream arg0) throws UnsupportedAudioFileException, IOException {
        throw new UnsupportedAudioFileException();
    }

    @Override
    public AudioInputStream getAudioInputStream(URL arg0) throws UnsupportedAudioFileException, IOException {
        if (!arg0.getFile().endsWith("." + fileFormatType.getExtension())) {
            throw new UnsupportedAudioFileException();
        }
        return new AudioInputStream(arg0.openStream(), this.format, -1L);
    }

    private static class RawAlawAudioFileFormatType
    extends AudioFileFormat.Type {
        public RawAlawAudioFileFormatType() {
            super("Raw Alaw 8kHz encoded", "al");
        }
    }
}

