/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.tools;

import ipsk.audio.AudioSource;
import ipsk.audio.AudioSourceException;
import ipsk.audio.arr.clip.AudioClip;
import javax.sound.sampled.AudioInputStream;

public class FrameUnitParser {
    public static final String SECONDS_SUFFIX = "s";
    public static final String MILLISECONDS_SUFFIX = "ms";
    public static final String END_CONSTANT = "end";
    long frameLength = -1L;
    float frameRate;

    public FrameUnitParser(float frameRate) {
        this.frameLength = -1L;
        this.frameRate = frameRate;
    }

    public FrameUnitParser(float frameRate, long frameLength) {
        this.frameLength = frameLength;
        this.frameRate = frameRate;
    }

    public FrameUnitParser(AudioInputStream ais) {
        this.frameLength = ais.getFrameLength();
        this.frameRate = ais.getFormat().getFrameRate();
    }

    public FrameUnitParser(AudioClip clip) throws AudioSourceException {
        this.frameLength = clip.getFrameLength();
        this.frameRate = clip.getFormat().getFrameRate();
    }

    public FrameUnitParser(AudioSource srcAs) throws AudioSourceException {
        this.frameLength = srcAs.getFrameLength();
        this.frameRate = srcAs.getFormat().getFrameRate();
    }

    public long parseValue(String s) {
        if (s.endsWith(MILLISECONDS_SUFFIX)) {
            String msStr = s.substring(0, s.length() - MILLISECONDS_SUFFIX.length());
            double msVal = Double.parseDouble(msStr);
            return (long)(msVal * (double)this.frameRate / 1000.0);
        }
        if (s.endsWith(SECONDS_SUFFIX)) {
            String sStr = s.substring(0, s.length() - SECONDS_SUFFIX.length());
            double sVal = Double.parseDouble(sStr);
            return (long)(sVal * (double)this.frameRate);
        }
        return Long.parseLong(s);
    }

    public long parseFrameUnitString(String s) {
        char operator;
        if (s.equals(END_CONSTANT)) {
            return this.frameLength;
        }
        if (s.startsWith(END_CONSTANT) && (operator = s.charAt(END_CONSTANT.length())) == '-') {
            return this.frameLength - this.parseValue(s.substring(s.indexOf(45) + 1));
        }
        return this.parseValue(s);
    }
}

