/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.ui;

import ipsk.audio.ui.AudioFormatChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AudioFileFormatChooser
extends AudioFormatChooser {
    protected AudioFileFormat audioFileFormat;
    protected AudioFileFormat.Type[] availTypes;
    protected JComboBox<AudioFileFormat.Type> fileTypeBox;
    protected AudioFileFormat.Type fileType;

    public AudioFileFormatChooser() {
        this.fileType = AudioFileFormat.Type.WAVE;
        this.audioFileFormat = new AudioFileFormat(this.fileType, this.getAudioFormat(), -1);
        this.create();
    }

    public AudioFileFormatChooser(AudioFormat audioFormat, AudioFileFormat.Type fileType) {
        super(audioFormat);
        this.fileType = fileType;
        this.audioFileFormat = new AudioFileFormat(fileType, audioFormat, -1);
        this.create();
    }

    private void create() {
        JLabel fileFormatLabel = new JLabel("File format");
        this.c.gridx = 0;
        ++this.c.gridy;
        this.add((Component)fileFormatLabel, this.c);
        this.availTypes = AudioSystem.getAudioFileTypes();
        this.fileTypeBox = new JComboBox<AudioFileFormat.Type>(this.availTypes);
        ++this.c.gridx;
        this.add(this.fileTypeBox, this.c);
    }

    public static AudioFileFormat showDialog(Component parent, AudioFileFormat initialFormat) {
        AudioFileFormatChooser afc = new AudioFileFormatChooser();
        afc.setAudioFileFormat(initialFormat);
        JOptionPane selPane = new JOptionPane(afc, -1, 2);
        JDialog d = selPane.createDialog(parent, "Audio file format chooser");
        d.setVisible(true);
        Object selectedValue = selPane.getValue();
        if (selectedValue == null) {
            return initialFormat;
        }
        if (selectedValue instanceof Integer) {
            int value = (Integer)selectedValue;
            if (value == 0) {
                return afc.getAudioFileFormat();
            }
            return initialFormat;
        }
        return initialFormat;
    }

    @Override
    public synchronized void actionPerformed(ActionEvent ev) {
        AudioFileFormat newAudioFileFormat = this.getAudioFileFormat();
        if (!this.audioFileFormat.equals(newAudioFileFormat)) {
            this.audioFileFormat = newAudioFileFormat;
            Enumeration e = this.listeners.elements();
            while (e.hasMoreElements()) {
                ChangeListener cl = (ChangeListener)e.nextElement();
                cl.stateChanged(new ChangeEvent(this));
            }
        }
    }

    public AudioFileFormat.Type getFileType() {
        if (this.fileTypeBox == null) {
            return null;
        }
        return (AudioFileFormat.Type)this.fileTypeBox.getSelectedItem();
    }

    public AudioFileFormat getAudioFileFormat() {
        this.fileType = this.getFileType();
        this.audioFileFormat = new AudioFileFormat(this.fileType, this.getAudioFormat(), this.audioFileFormat.getFrameLength());
        return this.audioFileFormat;
    }

    public void setAudioFileFormat(AudioFileFormat audioFileFormat) {
        this.fileType = audioFileFormat.getType();
        this.fileTypeBox.setSelectedItem(this.fileType);
        this.setAudioFormat(audioFileFormat.getFormat());
        this.audioFileFormat = audioFileFormat;
    }
}

