//    IPS Java Audio Tools
// 	  (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS Java Audio Tools
//
//
//    IPS Java Audio Tools is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS Java Audio Tools is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS Java Audio Tools.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.audio.ajs.impl.stdjs;

import ipsk.audio.ajs.MixerProviderServiceDescriptor;
import ipsk.util.LocalizableMessage;

/**
 * @author klausj
 *
 */
public class JavaSoundServiceDescriptor extends MixerProviderServiceDescriptor {

    
    public static final String AUDIO_INTERFACE_NAME="JavaSound";
    
    /* (non-Javadoc)
     * @see ipsk.audio.ajs.MixerProviderServiceDescriptor#getAudioInterfaceName()
     */
    @Override
    public String getAudioInterfaceName() {
       return AUDIO_INTERFACE_NAME;
    }


    /* (non-Javadoc)
     * @see ipsk.audio.ajs.MixerProviderServiceDescriptor#getServiceImplementationClassname()
     */
    @Override
    public String getServiceImplementationClassname() {
       
        return "ipsk.audio.ajs.impl.stdjs.JavaSoundMixerProvider";
    }

    /* (non-Javadoc)
     * @see ipsk.audio.ajs.MixerProviderServiceDescriptor#getTitle()
     */
    @Override
    public LocalizableMessage getTitle() {
     return new LocalizableMessage("Standard JavaSound");
    }
    
    public boolean isStandardJavaSoundWrapper() {
        return true;
    }

}
