/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.impl.j2audio;

import ipsk.audio.ThreadSafeAudioSystem;
import ipsk.audio.impl.j2audio.FileWriterListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;

public class FileWriterThread
extends Thread {
    private AudioInputStream ais;
    private AudioFileFormat.Type aff;
    private File outFile;
    private FileWriterListener listener;
    private int state;
    private Exception exception;
    public static final int IDLE = 0;
    public static final int WRITING = 1;
    public static final int DONE = 2;
    public static final int ERROR = -1;

    public FileWriterThread(FileWriterListener listener, AudioInputStream ais, AudioFileFormat.Type aff, File outFile) {
        this.listener = listener;
        this.ais = ais;
        this.aff = aff;
        this.outFile = outFile;
        this.state = 0;
        this.exception = null;
    }

    public void create() throws IOException {
        ByteArrayInputStream zeroBis = new ByteArrayInputStream(new byte[0]);
        AudioInputStream zeroAis = new AudioInputStream(zeroBis, this.ais.getFormat(), 0L);
        ThreadSafeAudioSystem.write(zeroAis, this.aff, this.outFile);
        zeroBis.close();
        zeroAis.close();
    }

    @Override
    public void run() {
        this.listener.update(this, 1);
        try {
            ThreadSafeAudioSystem.write(this.ais, this.aff, this.outFile);
            this.ais.close();
        }
        catch (IOException e) {
            this.exception = e;
            this.state = -1;
            this.listener.update(this, this.state);
        }
        this.listener.update(this, 2);
    }

    public Exception getException() {
        return this.exception;
    }
}

