/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.io;

import java.awt.Component;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.swing.ProgressMonitor;

public class ProgressMeasuringAudioInputStream
extends AudioInputStream {
    private AudioInputStream srcAudioInputStream;
    private int frameSize;
    private int position;
    private long frameLength;
    private ProgressMonitor progressMonitor;

    public ProgressMeasuringAudioInputStream(AudioInputStream srcAudioInputStream, Component parentComponent, Object message, String note) {
        super(srcAudioInputStream, srcAudioInputStream.getFormat(), srcAudioInputStream.getFrameLength());
        this.srcAudioInputStream = srcAudioInputStream;
        AudioFormat audioFormat = srcAudioInputStream.getFormat();
        this.frameSize = audioFormat.getFrameSize();
        this.frameLength = srcAudioInputStream.getFrameLength();
        this.position = 0;
        this.progressMonitor = new ProgressMonitor(parentComponent, message, note, 0, (int)(this.frameLength * (long)this.frameSize));
        this.progressMonitor.setMillisToDecideToPopup(0);
    }

    @Override
    public int available() throws IOException {
        return this.srcAudioInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.srcAudioInputStream.close();
        this.progressMonitor.close();
    }

    @Override
    public AudioFormat getFormat() {
        return this.srcAudioInputStream.getFormat();
    }

    @Override
    public long getFrameLength() {
        return this.srcAudioInputStream.getFrameLength();
    }

    @Override
    public synchronized void mark(int arg0) {
        this.srcAudioInputStream.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        return this.srcAudioInputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new InterruptedIOException("Audio I/O transfer cancelled");
        }
        byte[] buf = new byte[1];
        int read = this.read(buf, 0, 1);
        if (read == -1) {
            return -1;
        }
        return 0xFF & read;
    }

    @Override
    public int read(byte[] buf) throws IOException {
        return this.read(buf, 0, buf.length);
    }

    @Override
    public int read(byte[] buf, int offset, int len) throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new InterruptedIOException("Audio I/O transfer cancelled");
        }
        int read = this.srcAudioInputStream.read(buf, offset, len);
        if (read == -1) {
            return read;
        }
        this.position += read;
        this.progressMonitor.setProgress(this.position);
        return read;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new InterruptedIOException("Audio I/O transfer cancelled");
        }
        this.srcAudioInputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.progressMonitor.isCanceled()) {
            throw new InterruptedIOException("Audio I/O transfer cancelled");
        }
        long skipped = this.srcAudioInputStream.skip(n);
        this.position = (int)((long)this.position + n);
        return skipped;
    }

    public String toString() {
        return new String("Progress monitoring audio stream based on:" + this.srcAudioInputStream.toString());
    }
}

