/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer;

import ipsk.audio.mixer.MixerManagerListener;
import java.awt.Dimension;
import java.util.Vector;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.CompoundControl;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.EnumControl;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class MixerManager {
    public static final boolean DEBUG = false;
    public static Port.Info[] KNOWN_PORTS = new Port.Info[]{Port.Info.SPEAKER, Port.Info.HEADPHONE, Port.Info.MICROPHONE, Port.Info.COMPACT_DISC, Port.Info.LINE_IN, Port.Info.LINE_OUT};
    private Mixer.Info[] mi;
    private Mixer selectedPlaybackMixer;
    private Mixer selectedCaptureMixer;
    private Vector<MixerManagerListener> listenerList;
    private DataLine.Info sourceDataLineInfo = new DataLine.Info(SourceDataLine.class, null);
    private DataLine.Info targetDataLineInfo = new DataLine.Info(TargetDataLine.class, null);

    public MixerManager() {
        this.mi = AudioSystem.getMixerInfo();
        this.listenerList = new Vector();
    }

    public synchronized Mixer[] getPlaybackMixers() throws LineUnavailableException {
        return this.getPlaybackMixers(false);
    }

    public Mixer getCaptureMixerByName(String name) {
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            Line.Info[] tlInfos = m.getTargetLineInfo(this.targetDataLineInfo);
            if (tlInfos == null || tlInfos.length <= 0 || !this.mi[i].getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Mixer getCaptureMixerByName(String name, boolean open) throws LineUnavailableException {
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] tlInfos = m.getTargetLineInfo(this.targetDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (tlInfos == null || tlInfos.length <= 0 || !this.mi[i].getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Mixer getPlaybackMixerByName(String name) {
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            Line.Info[] slInfos = m.getSourceLineInfo(this.sourceDataLineInfo);
            if (slInfos == null || slInfos.length <= 0 || !this.mi[i].getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public Mixer getPlaybackMixerByName(String name, boolean open) throws LineUnavailableException {
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] slInfos = m.getSourceLineInfo(this.sourceDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (slInfos == null || slInfos.length <= 0 || !this.mi[i].getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public synchronized Mixer[] getPlaybackMixers(boolean open) throws LineUnavailableException {
        Vector<Mixer> playbackMixers = new Vector<Mixer>();
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] slInfos = m.getSourceLineInfo(this.sourceDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (slInfos == null || slInfos.length <= 0) continue;
            playbackMixers.add(m);
        }
        return playbackMixers.toArray(new Mixer[0]);
    }

    public synchronized Mixer[] getDirectPlaybackMixers() throws LineUnavailableException {
        return this.getDirectPlaybackMixers(false);
    }

    public synchronized Mixer[] getDirectPlaybackMixers(boolean open) throws LineUnavailableException {
        Vector<Mixer> playbackMixers = new Vector<Mixer>();
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] slInfos = m.getSourceLineInfo(this.sourceDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (slInfos == null || slInfos.length <= 0 || m.getMixerInfo().getName().equals("Java Sound Audio Engine")) continue;
            playbackMixers.add(m);
        }
        if (playbackMixers.size() == 0) {
            return this.getPlaybackMixers(open);
        }
        return playbackMixers.toArray(new Mixer[0]);
    }

    public synchronized Mixer.Info[] getPlaybackMixerInfos() throws LineUnavailableException {
        return this.getPlaybackMixerInfos(false);
    }

    public synchronized Mixer.Info[] getPlaybackMixerInfos(boolean open) throws LineUnavailableException {
        Vector<Mixer.Info> playbackMixers = new Vector<Mixer.Info>();
        for (int i = 0; i < this.mi.length; ++i) {
            Mixer m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] slInfos = m.getSourceLineInfo(this.sourceDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (slInfos == null || slInfos.length <= 0) continue;
            playbackMixers.add(this.mi[i]);
        }
        return playbackMixers.toArray(new Mixer.Info[0]);
    }

    public synchronized Mixer[] getCaptureMixers() throws LineUnavailableException {
        return this.getCaptureMixers(false);
    }

    public synchronized Mixer[] getCaptureMixers(boolean open) throws LineUnavailableException {
        Vector<Mixer> captureMixers = new Vector<Mixer>();
        Mixer m = null;
        for (int i = 0; i < this.mi.length; ++i) {
            m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] tlInfos = m.getTargetLineInfo(this.targetDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (tlInfos == null || tlInfos.length <= 0) continue;
            captureMixers.add(m);
        }
        return captureMixers.toArray(new Mixer[0]);
    }

    public synchronized Mixer.Info[] getCaptureMixerInfos() throws LineUnavailableException {
        return this.getCaptureMixerInfos(false);
    }

    public synchronized Mixer.Info[] getCaptureMixerInfos(boolean open) throws LineUnavailableException {
        Vector<Mixer.Info> captureMixers = new Vector<Mixer.Info>();
        for (int i = 0; i < this.mi.length; ++i) {
            Mixer m = AudioSystem.getMixer(this.mi[i]);
            boolean wasOpen = m.isOpen();
            if (!wasOpen && open) {
                m.open();
            }
            Line.Info[] tlInfos = m.getTargetLineInfo(this.targetDataLineInfo);
            if (!wasOpen && open) {
                m.close();
            }
            if (tlInfos == null || tlInfos.length <= 0) continue;
            captureMixers.add(this.mi[i]);
        }
        return captureMixers.toArray(new Mixer.Info[0]);
    }

    public Mixer getSelectedCaptureMixer() {
        return this.selectedCaptureMixer;
    }

    public Mixer getSelectedPlaybackMixer() {
        return this.selectedPlaybackMixer;
    }

    public void setSelectedCaptureMixer(Mixer mixer) {
        this.selectedCaptureMixer = mixer;
        this.fireSelectedCaptureMixerChanged();
    }

    public void setSelectedPlaybackMixer(Mixer mixer) {
        this.selectedPlaybackMixer = mixer;
        this.fireSelectedPlaybackMixerChanged();
    }

    private String printMixer(Mixer m) {
        return "Mixer: " + m.getMixerInfo().getName() + ":\n";
    }

    public String printPort(Mixer m, Port.Info pi) throws LineUnavailableException {
        StringBuffer sb = new StringBuffer("Port: " + pi.getName() + "\n");
        Line tgtLine = m.getLine(pi);
        if (tgtLine instanceof Port) {
            Control[] pCtrls;
            Port tgtPort = (Port)tgtLine;
            tgtPort.open();
            for (Control pCtrl : pCtrls = tgtPort.getControls()) {
                sb.append(this.printControl(pCtrl));
            }
            tgtPort.close();
        }
        return sb.toString();
    }

    private String printControl(Control c) {
        StringBuffer sb = new StringBuffer();
        if (c instanceof CompoundControl) {
            Control[] ccms;
            CompoundControl cc = (CompoundControl)c;
            sb.append("Compound control: " + cc.getType().toString() + "\n");
            for (Control cm : ccms = cc.getMemberControls()) {
                sb.append(this.printControl(cm));
            }
        } else if (c instanceof FloatControl) {
            FloatControl fc = (FloatControl)c;
            sb.append("Float control: " + fc.getType() + " Min: " + fc.getMinimum() + " Max: " + fc.getMaximum() + " Val: " + fc.getValue() + "\n");
        } else if (c instanceof BooleanControl) {
            BooleanControl bc = (BooleanControl)c;
            sb.append("Boolean control: " + bc.getType() + " Val: " + bc.getValue() + " Label:" + bc.getStateLabel(bc.getValue()) + "\n");
        } else if (c instanceof EnumControl) {
            EnumControl ec = (EnumControl)c;
            sb.append("Enum control: " + ec.getType() + " Val: " + ec.getValue() + "\n");
        }
        return sb.toString();
    }

    public String printPortControls() throws LineUnavailableException {
        Mixer.Info[] mInfos;
        StringBuffer sb = new StringBuffer();
        for (Mixer.Info info : mInfos = AudioSystem.getMixerInfo()) {
            Line.Info[] srcLineInfos;
            Line.Info[] tgtLineInfos;
            Control[] mcs;
            Mixer m = AudioSystem.getMixer(info);
            m.open();
            boolean mixerPrinted = false;
            for (Control mc : mcs = m.getControls()) {
                if (!mixerPrinted) {
                    sb.append(this.printMixer(m));
                    mixerPrinted = true;
                }
                sb.append(this.printControl(mc));
            }
            for (Line.Info tgtLineInfo : tgtLineInfos = m.getTargetLineInfo()) {
                if (!(tgtLineInfo instanceof Port.Info)) continue;
                Port.Info tgtPortInfo = (Port.Info)tgtLineInfo;
                if (!mixerPrinted) {
                    sb.append(this.printMixer(m));
                    mixerPrinted = true;
                }
                sb.append(this.printPort(m, tgtPortInfo));
            }
            for (Line.Info srcLineInfo : srcLineInfos = m.getSourceLineInfo()) {
                if (!(srcLineInfo instanceof Port.Info)) continue;
                Port.Info srcPortInfo = (Port.Info)srcLineInfo;
                if (!mixerPrinted) {
                    sb.append(this.printMixer(m));
                    mixerPrinted = true;
                }
                sb.append(this.printPort(m, srcPortInfo));
            }
            m.close();
            if (!mixerPrinted) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized void addMixerManagerListener(MixerManagerListener acl) {
        if (acl != null && !this.listenerList.contains(acl)) {
            this.listenerList.addElement(acl);
        }
    }

    public synchronized void removeMixerManagerListener(MixerManagerListener acl) {
        if (acl != null) {
            this.listenerList.removeElement(acl);
        }
    }

    protected synchronized void fireSelectedPlaybackMixerChanged() {
        for (MixerManagerListener listener : this.listenerList) {
            listener.selectedPlaybackMixerChanged(this, this.selectedPlaybackMixer);
        }
    }

    protected synchronized void fireSelectedCaptureMixerChanged() {
        for (MixerManagerListener listener : this.listenerList) {
            listener.selectedCaptureMixerChanged(this, this.selectedCaptureMixer);
        }
    }

    public void setSelectedPlaybackMixer(Mixer.Info info) {
        this.selectedPlaybackMixer = info == null ? null : AudioSystem.getMixer(info);
        this.fireSelectedPlaybackMixerChanged();
    }

    public void setSelectedCaptureMixer(Mixer.Info selectedCaptureMixerInfo) {
        this.selectedCaptureMixer = selectedCaptureMixerInfo == null ? null : AudioSystem.getMixer(selectedCaptureMixerInfo);
        this.fireSelectedCaptureMixerChanged();
    }

    public static void main(String[] args) {
        try {
            MixerManager mm = new MixerManager();
            JTextPane tp = new JTextPane();
            JScrollPane sp = new JScrollPane(tp);
            tp.setPreferredSize(new Dimension(300, 400));
            JFrame f = new JFrame();
            f.setDefaultCloseOperation(3);
            f.getContentPane().add(sp);
            f.pack();
            f.setVisible(true);
            tp.setText(mm.printPortControls());
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }
}

