/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.LineControlsUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.Port;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Scrollable;

public class FilteredMixerPortsUI
extends JPanel
implements Scrollable {
    static final boolean DEBUG = false;
    private ResourceBundle rb;
    private Vector<Port.Info> portInfos;
    private Line[] ports;
    private int numPorts;
    private JPanel portsPanel;
    private Vector<LineControlsUI> lineControls = new Vector();

    public FilteredMixerPortsUI(Mixer mixer, boolean isSource) {
        this.portsPanel = new JPanel();
        this.portsPanel.setLayout(new GridBagLayout());
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.fill = 3;
        c.anchor = 11;
        c.gridx = 0;
        c.gridy = 0;
        this.portInfos = new Vector();
        Line.Info[] sourceLineInfos = mixer.getSourceLineInfo();
        for (int i = 0; i < sourceLineInfos.length; ++i) {
            if (!(sourceLineInfos[i] instanceof Port.Info)) continue;
            this.portInfos.add((Port.Info)sourceLineInfos[i]);
        }
        Line.Info[] targetLineInfos = mixer.getTargetLineInfo();
        for (int i = 0; i < targetLineInfos.length; ++i) {
            if (!(targetLineInfos[i] instanceof Port.Info)) continue;
            this.portInfos.add((Port.Info)targetLineInfos[i]);
        }
        int nPorts = this.portInfos.size();
        this.ports = new Line[nPorts];
        for (int i = 0; i < nPorts; ++i) {
            Line.Info info = this.portInfos.get(i);
            Port.Info pi = (Port.Info)info;
            if (pi.isSource() != isSource) continue;
            ++this.numPorts;
            Line l = null;
            try {
                l = mixer.getLine(info);
                l.open();
            }
            catch (LineUnavailableException e) {
                JOptionPane.showMessageDialog(this, this.rb.getString("error_audio_system"), e.getLocalizedMessage(), 0);
            }
            ++c.gridx;
            LineControlsUI lc = new LineControlsUI(l);
            this.lineControls.add(lc);
            this.portsPanel.add((Component)((Object)lc), c);
        }
        this.add(this.portsPanel);
    }

    public void close() {
        for (int i = 0; i < this.ports.length; ++i) {
            this.ports[i].close();
        }
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        double height = this.getPreferredSize().getHeight();
        return new Dimension(-1, (int)height);
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
        return 0;
    }

    public int getNumPorts() {
        return this.numPorts;
    }

    public void setNumPorts(int numPorts) {
        this.numPorts = numPorts;
    }

    public void updateValue() {
        for (LineControlsUI lc : this.lineControls) {
            lc.updateValue();
        }
    }
}

