/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.mixer.ui;

import ipsk.audio.mixer.ui.FilteredMixerPortsUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ResourceBundle;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class MixerPortsUI
extends JPanel {
    static final boolean DEBUG = false;
    static final boolean USE_SCROLL_PANES = false;
    private ResourceBundle rb;
    private FilteredMixerPortsUI capturePortsPanel;
    private FilteredMixerPortsUI playbackPortsPanel;
    private JTabbedPane portPanels;
    private Mixer.Info mixerInfo;
    private Line[] ports;
    int numPorts;

    public MixerPortsUI(Mixer mixer) {
        String packageName = this.getClass().getPackage().getName();
        this.rb = ResourceBundle.getBundle(packageName + ".ResBundle");
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.weightx = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        this.portPanels = new JTabbedPane();
        this.playbackPortsPanel = new FilteredMixerPortsUI(mixer, false);
        this.capturePortsPanel = new FilteredMixerPortsUI(mixer, true);
        this.mixerInfo = mixer.getMixerInfo();
        JLabel descLabel = new JLabel(this.rb.getString("description") + ":" + this.mixerInfo.getDescription());
        this.add((Component)descLabel, c);
        ++c.gridy;
        JLabel vendorLabel = new JLabel(this.rb.getString("vendor") + ":" + this.mixerInfo.getVendor());
        this.add((Component)vendorLabel, c);
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        if (this.playbackPortsPanel.getNumPorts() > 0) {
            this.portPanels.addTab(this.rb.getString("playback"), this.playbackPortsPanel);
        }
        if (this.capturePortsPanel.getNumPorts() > 0) {
            this.portPanels.addTab(this.rb.getString("capture"), this.capturePortsPanel);
        }
        ++c.gridy;
        this.add((Component)this.portPanels, c);
    }

    public void updateValue() {
        this.playbackPortsPanel.updateValue();
        this.capturePortsPanel.updateValue();
    }

    public void close() {
        for (int i = 0; i < this.numPorts; ++i) {
            this.ports[i].close();
        }
    }
}

