/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.plugins;

import ipsk.audio.AudioPluginException;
import ipsk.audio.arr.Selection;
import ipsk.audio.plugins.BasicPCMPlugin;
import ipsk.io.EditInputStream;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class EditPlugin
extends BasicPCMPlugin {
    private long from;
    private long length;
    private AudioFormat af;
    private long frameLength;
    private int frameSize;

    public EditPlugin(long from, long length) {
        this.from = from;
        this.length = length;
    }

    public EditPlugin(Selection s) {
        this(s.getLeft(), s.getLength());
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioInputStream ais) throws AudioPluginException {
        this.frameLength = ais.getFrameLength();
        this.af = ais.getFormat();
        this.frameSize = this.af.getFrameSize();
        if (this.from == -1L) {
            this.from = this.frameLength;
        }
        if (this.length == -1L) {
            this.length = this.frameLength;
        }
        if (this.from + this.length > this.frameLength) {
            this.length = this.frameLength - this.from;
        }
        EditInputStream eis = new EditInputStream((InputStream)ais, this.frameSize, this.from, this.length);
        AudioInputStream editAudioInputStream = new AudioInputStream((InputStream)eis, this.af, this.length);
        return editAudioInputStream;
    }
}

