/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.utils;

public class EnvironmentChecker {
    public String checkJRE() {
        String osName = System.getProperty("os.name");
        String jreVersion = System.getProperty("java.version");
        String jreVendor = System.getProperty("java.vendor");
        if (osName.equals("Windows")) {
            if (!jreVendor.equals("Sun")) {
                return new String("Unknown JRE vendor: " + jreVendor + ".");
            }
            if (jreVersion.startsWith("1.5.0")) {
                String updateVersionStr = jreVersion.substring(jreVersion.indexOf("_") + 1);
                int updateVersion = Integer.parseInt(updateVersionStr);
                if (updateVersion >= 7) {
                    return null;
                }
                return new String("JRE Version " + jreVersion + " for Windows contains an audio bug ID 6261423 !\nPlease update to at least JRE 1.5.0 Update 7.");
            }
            if (jreVersion.compareTo("1.6") > 0) {
                return null;
            }
            return new String("Windows JRE version " + jreVersion + " not supported.\nPlease update your JAVA environment.");
        }
        if (jreVersion.compareTo("1.5.0") < 0) {
            return new String("JRE version " + jreVersion + " not supported !\nPlease update your JAVA version.");
        }
        return null;
    }

    public static void main(String[] args) {
        EnvironmentChecker envChecker = new EnvironmentChecker();
        System.out.println("Check JRE: " + envChecker.checkJRE());
        System.exit(0);
    }
}

