/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.arr;

import ipsk.audio.arr.Marker;

public class Selection
implements Cloneable {
    protected Marker startMarker;
    protected Marker endMarker;
    protected String name;
    protected int[] channels = null;

    public Selection() {
        this(new Marker(), new Marker(), null);
    }

    public Selection(Marker startMarker, Marker endMarker) {
        this(startMarker, endMarker, null);
    }

    public Selection(long start, long end) {
        this(new Marker(start), new Marker(end), null);
    }

    public Selection(Marker startMarker, Marker endMarker, String name) {
        this.startMarker = startMarker;
        this.endMarker = endMarker;
        this.name = name;
    }

    public synchronized boolean isInSelection(long pos) {
        return pos >= this.startMarker.position && pos <= this.endMarker.position || pos <= this.startMarker.position && pos >= this.endMarker.position;
    }

    public long getLeft() {
        return this.startMarker.position <= this.endMarker.position ? this.startMarker.position : this.endMarker.position;
    }

    public long getRight() {
        return this.startMarker.position <= this.endMarker.position ? this.endMarker.position : this.startMarker.position;
    }

    public long getLength() {
        return Math.abs(this.endMarker.position - this.startMarker.position) + 1L;
    }

    public void setStart(long l) {
        this.startMarker.setPosition(l);
    }

    public void setEnd(long l) {
        this.endMarker.setPosition(l);
    }

    public long getStart() {
        return this.startMarker.getPosition();
    }

    public long getEnd() {
        return this.endMarker.getPosition();
    }

    public void limitTo(long startLimit, long endLimit) {
        if (this.startMarker.position <= this.endMarker.position) {
            if (this.startMarker.position < startLimit) {
                this.startMarker.setPosition(startLimit);
            }
            if (this.endMarker.position > endLimit) {
                this.endMarker.setPosition(endLimit);
            }
        } else {
            if (this.startMarker.position > endLimit) {
                this.startMarker.setPosition(endLimit);
            }
            if (this.endMarker.position < startLimit) {
                this.endMarker.setPosition(startLimit);
            }
        }
    }

    public Marker getEndMarker() {
        return this.endMarker;
    }

    public void setEndMarker(Marker endMarker) {
        this.endMarker = endMarker;
    }

    public Marker getStartMarker() {
        return this.startMarker;
    }

    public void setStartMarker(Marker startMarker) {
        this.startMarker = startMarker;
    }

    public Object clone() throws CloneNotSupportedException {
        Selection clone = null;
        clone = this.name != null ? new Selection((Marker)this.startMarker.clone(), (Marker)this.endMarker.clone(), new String(this.name)) : new Selection((Marker)this.startMarker.clone(), (Marker)this.endMarker.clone());
        return clone;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Selection)) {
            return false;
        }
        Selection s = (Selection)o;
        return (s.getName() == null && this.name == null || s.getName().equals(this.name)) && s.getStartMarker().equals(this.startMarker) && s.getEndMarker().equals(this.endMarker);
    }

    public String toString() {
        return new String("Selection: " + this.getStart() + "-" + this.getEnd());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getChannels() {
        return this.channels;
    }

    public void setChannels(int[] channels) {
        this.channels = channels;
    }
}

