/*
 * Decompiled with CFR 0.152.
 */
package ipsk.audio.dsp.speech;

import ipsk.audio.dsp.speech.SpeechFinalSilenceDetectorEvent;
import ipsk.audio.dsp.speech.SpeechFinalSilenceDetectorListener;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetector;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetectorEvent;
import ipsk.audio.dsp.speech.vad.VoiceActivityDetectorListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class SpeechFinalSilenceDetector
implements VoiceActivityDetectorListener,
ActionListener {
    private static boolean DEBUG = false;
    private double DEFAULT_SILENCE_LENGTH;
    private VoiceActivityDetector voiceActivityDetector;
    private SpeechFinalSilenceDetectorListener listener;
    private double silencelength;
    private boolean voiceDetected;
    private Timer finalSilenceTimer;
    private boolean running;

    public SpeechFinalSilenceDetector(VoiceActivityDetector voiceActivityDetector, SpeechFinalSilenceDetectorListener listener) {
        this.silencelength = this.DEFAULT_SILENCE_LENGTH = 4.0;
        this.voiceDetected = false;
        this.running = false;
        this.voiceActivityDetector = voiceActivityDetector;
        this.listener = listener;
        this.voiceActivityDetector.setVoiceActivityDetectorListener(this);
    }

    @Override
    public void update(VoiceActivityDetectorEvent event) {
        if (event.isVoiced()) {
            if (DEBUG) {
                System.out.println("Received voiced event.");
            }
            this.voiceDetected = true;
            if (this.finalSilenceTimer != null) {
                this.finalSilenceTimer.stop();
            }
        } else {
            if (DEBUG) {
                System.out.println("Received unvoiced event.");
            }
            if (this.running && this.voiceDetected) {
                int finalSilenceMs = (int)(this.silencelength * 1000.0);
                if (this.finalSilenceTimer == null) {
                    this.finalSilenceTimer = new Timer(finalSilenceMs, this);
                    this.finalSilenceTimer.setRepeats(false);
                    this.finalSilenceTimer.start();
                } else {
                    this.finalSilenceTimer.setInitialDelay(finalSilenceMs);
                    this.finalSilenceTimer.setDelay(finalSilenceMs);
                    this.finalSilenceTimer.restart();
                }
            }
        }
    }

    public void start() {
        this.running = true;
    }

    public void stop() {
        this.running = false;
        this.reset();
    }

    public void reset() {
        this.voiceDetected = false;
        if (this.finalSilenceTimer != null) {
            this.finalSilenceTimer.stop();
        }
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (DEBUG) {
            System.out.println("Silence detected.");
        }
        if (this.listener != null && this.running) {
            this.listener.update(new SpeechFinalSilenceDetectorEvent(this));
        }
    }

    public double getSilencelength() {
        return this.silencelength;
    }

    public void setSilencelength(double silencelength) {
        this.silencelength = silencelength;
    }
}

